/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/* 
 * NOTE: I borrowed some ideas from Russ Allbery <rra@stanford.edu> when I
 * hacked this together, and as such, his name goes in this file. :)
 */

#include "includes.h"

/* Read a TAI64N external format timestamp from stdin and write fractional
   seconds since epoch (TAI, not UTC) to stdout.  Return the character after
   the timestamp. */

time_t t64nfrac(char *sline) {
	short int c;
    	short int i = 1;
    	unsigned long u;
    	unsigned long seconds = 0;
    	unsigned long nanoseconds = 0;
	unsigned long long test = 4611686018427387914; /* ULL; */
    	char line[LSIZE];
	
	strcpy(line, sline);

    	while ((c = line[i]) != '\0') {
	    	u = c - '0';
		if (u >= 10) {
		    	u = c - 'a';
	    		if (u >= 6) break;
	    		u += 10;
		}
		seconds <<= 4;
		seconds += nanoseconds >> 28;
		nanoseconds &= 0xfffffff;
		nanoseconds <<= 4;
		nanoseconds += u;
		++i;
    	}
	seconds -= test; /* 4611686018427387914ULL; */
	return (seconds);
}


