/*
 *  Linux snipes, a text-based maze-oriented game for linux.
 *  Copyright (C) 1997 Jeremy Boulton.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Jeremy Boulton is reachable via electronic mail at
 *  boultonj@ugcs.caltech.edu.
 */

/* kbd.h */

#ifndef SNIPES_KBD

#define SNIPES_KBD


enum KbdAction {
  MOVE_ACTION,
  QUIT_ACTION,
  SUSPEND_ACTION
};

enum KbdMode {
  KMODE_NORMAL,
  KMODE_ACTION
};

struct kbd_action {
  signed int fx, fy;		/* -1, 0, 1 for left/up, nothing, right/down */
  signed int mx, my;
  char accel;
  enum KbdAction action;
};

int init_kbd( enum DisplayType disptype, int use_raw_mode );
int close_kbd( void );
void emergency_close_kbd( void );
void kbd_setmode( enum KbdMode km );
int kbd_getch( void );
int get_kbd_action( struct kbd_action *ka );
void wait_kbd_action( void );


#endif /* SNIPES_KBD */
