/*
 *	@(#)pmaptst.c	1.3 98/11/30 Connectathon Testsuite
 *	1.3 Lachman ONC Test Suite source
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>

#define RPCINFO "rpcinfo -p"

#ifdef SVR3
#define PROG    ((ulong)432123)
#define VERS	((ulong)4)
#else
#define PROG    ((u_long)432123)
#define VERS	((u_long)4)
#endif
#define UPORT    2345
#define TPORT    2346

#ifndef ARGS_
#ifdef __STDC__
#define ARGS_(x) x
#else
#define ARGS_(x) ()
#endif
#endif

extern int pmap_set ARGS_((u_int prog, u_int vers, u_int proto, u_short port));
extern int pmap_unset ARGS_((u_int prog, u_int vers));

/*ARGSUSED*/
int
main(argc, argv)
	int argc;
	char **argv;
{
	int errs = 0;

	printf("portmapper set/unset test.\n");
	printf("rpcinfo before pmap_set:\n");
	system(RPCINFO);

	printf("\n--- Registering udp program %lu version %lu port %d...  ",
		(u_long)PROG, (u_long)VERS, UPORT);
	if (pmap_set(PROG, VERS, IPPROTO_UDP, UPORT))
		printf("done.\n");
	else {
		printf("failed.\n");
		errs++;
	}
	printf("rpcinfo after udp pmap_set:\n");
	system(RPCINFO);

	printf("\n--- Registering tcp program %lu version %lu port %d...  ",
		(u_long)PROG, (u_long)VERS, TPORT);
	if (pmap_set(PROG, VERS, IPPROTO_TCP, TPORT))
		printf("done.\n");
	else {
		printf("failed.\n");
		errs++;
	}
	printf("rpcinfo after tcp pmap_set:\n");
	system(RPCINFO);

	printf("\n--- Unregistering program %lu version %lu... ",
	       (u_long)PROG, (u_long)VERS);
	if (pmap_unset(PROG, VERS))
		printf("done.\n");
	else {
		printf("failed.\n");
		errs++;
	}
	printf("rpcinfo after pmap_unset:\n");
	system(RPCINFO);
	if (!errs)
		printf("Test complete ok\n");
	exit(errs);
}
