-------------------------------------------------------------------------------
--                                                                           --
--  Ada Interface to the X Window System and Motif(tm)/Lesstif               --
--  Copyright (c) 1996-2000 Hans-Frieder Vogt                                --
--                                                                           --
--  This program is free software; you can redistribute it and/or modify     --
--  it under the terms of the GNU General Public License as published by     --
--  the Free Software Foundation; either version 2 of the License, or        --
--  (at your option) any later version.                                      --
--                                                                           --
--  This program is distributed in the hope that it will be useful,          --
--  but WITHOUT ANY WARRANTY; without even the implied warranty of           --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.                     --
--  See the GNU General Public License for more details.                     --
--                                                                           --
--  You should have received a copy of the GNU General Public License        --
--  along with this program; if not, write to the                            --
--  Free Software Foundation, Inc.,                                          --
--  59 Temple Place - Suite 330,                                             --
--  Boston, MA 02111-1307, USA.                                              --
--                                                                           --
--                                                                           --
--  X Window System is copyrighted by the X Consortium                       --
--  Motif(tm)       is copyrighted by the Open Software Foundation, Inc.     --
--                                                                           --
--                                                                           --
-------------------------------------------------------------------------------

-------------------------------------------------------------------------------
--
-- HISTORY:
--          June 20, 1998 begin of history
--          July 9, 1998 HFVogt: adapted type name Host_Family to new writing
--          October 10, 1998 HFVogt: adapted to new package X_Connection
--                           corrected an error for case "others"
--          3 Mar 2002 H.-F. Vogt: replace System.Unsigned_Types by Interfaces.C--                                 types
--
-------------------------------------------------------------------------------

with X_Lib.Host_Access,
     X_Connection,
     Ada.Text_Io,
     Interfaces.C;
procedure Show_Hosts is

   Display  : X_Lib.Display_Pointer;

   package Mod_Io is
      new Ada.Text_Io.Modular_Io (Interfaces.C.unsigned_char);

   Host_List : X_Lib.Host_Access.X_Host_Address_List;
   Enabled   : Boolean;

begin

   Display := X_Lib.X_Open_Display;

   X_Lib.Host_Access.X_List_Hosts (Display, Host_List, Enabled);
   if Enabled then
      Ada.Text_Io.Put_Line ("access control enabled, only authorized clients can connect");
   else
      Ada.Text_Io.Put_Line ("access control disabled, every client can connect");
   end if;
   
   for I in 1 .. X_Lib.Host_Access.Length (Host_List) loop
      declare
         Host : constant X_Lib.Host_Access.X_Host_Address
	      := X_Lib.Host_Access.Element (Host_List, I);
      begin
         case Host.Family is
            when X_Connection.Family_Internet =>
               Ada.Text_Io.Put ("Internet: ");
               for J in Host.Host_Name'First .. Host.Host_Name'Last-1 loop
                  Mod_Io.Put (Host.Host_Name (J), Width => 0);
                  Ada.Text_Io.Put (".");
               end loop;
               Mod_Io.Put (Host.Host_Name (Host.Host_Name'Last), Width => 0);
            when X_Connection.Family_DEC_Net =>
               Ada.Text_Io.Put ("DECnet: ");
               for J in reverse Host.Host_Name'First+1 .. Host.Host_Name'Last loop
                  Mod_Io.Put (Host.Host_Name (J), Width => 0);
                  Ada.Text_Io.Put (":");
               end loop;
               Mod_Io.Put (Host.Host_Name (Host.Host_Name'First), Width => 0);
            when X_Connection.Family_Chaos =>
               Ada.Text_Io.Put ("Chaos: ");
               for J in Host.Host_Name'First .. Host.Host_Name'Last-1 loop
                  Mod_Io.Put (Host.Host_Name (J), Width => 0);
                  Ada.Text_Io.Put (",");
               end loop;
               Mod_Io.Put (Host.Host_Name (Host.Host_Name'Last), Width => 0);
            when others =>
               Ada.Text_Io.Put ("Unknown Address Family (" &
	                        X_Connection.Protocol_Family'Image (Host.Family) & "): ");
               for J in Host.Host_Name'First .. Host.Host_Name'Last loop
                  Mod_Io.Put (Host.Host_Name (J), Width => 0);
                  if J /= Host.Host_Name'Last then
                     Ada.Text_Io.Put (",");
                  end if;
               end loop;
         end case;
         Ada.Text_Io.New_Line;
      end;
   end loop;
end Show_Hosts;
