/*
   Copyright (C) 2003 Commonwealth Scientific and Industrial Research
   Organisation (CSIRO) Australia

   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions
   are met:

   - Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

   - Neither the name of CSIRO Australia nor the names of its
   contributors may be used to endorse or promote products derived from
   this software without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
   ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
   LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
   PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE ORGANISATION OR
   CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
   EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
   PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
   PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
   LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
   NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
   SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef __ANX_DEPRECATED_H__
#define __ANX_DEPRECATED_H__

/** \file
 * Deprecated functions related to Annodex media
 */

#include <annodex/anx_types.h>

/**
 * DEPRECATED TYPE
 * A track of data
 */
struct _AnxTrack {
  long serialno;          /*< The serialno of the Ogg logical bitstream */  
  char * id;              /*< The text id of the track */
  char * content_type;    /*< Content type of track contents */
  long nr_header_packets; /*< number of extra header packets */
  anx_int64_t granule_rate_n;  /*< the granule rate numerator */
  anx_int64_t granule_rate_d;  /*< the granule rate denominator */
  anx_int64_t basegranule;     /*< Base granule */
  int preroll;            /*< Preroll */
  int granuleshift;       /*< Granuleshift */
};


/**
 * DEPRECATED FUNCTION
 * Query the basetime of an annodex.
 * In Annodex v2, the basetime was confusingly called "timebase"
 * \param annodex an ANNODEX* handle
 * \returns the basetime of the annodex
 */
double anx_get_timebase (ANNODEX * annodex);

/**
 * DEPRECATED FUNCTION
 * Set the basetime of an annodex.
 * In Annodex v2, the basetime was confusingly called "timebase"
 * \param annodex an ANNODEX* handle
 * \param seconds the new basetime
 */
double anx_set_timebase (ANNODEX * annodex, double seconds);

#endif /* __ANX_DEPRECATED_H__ */
