/*
 * id->package mapping
 *
 * Copyright (C) 2006  Enrico Zini <enrico@debian.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <apt-front/updater.h>
#include <apt-front/cache/component/debtags/pkgidx.h>
#include <apt-front/cache/entity/package.h>
#include <apt-front/utils/paths.h>

using namespace aptFront::cache;
using namespace component;
using namespace debtags;
using namespace std;
using namespace Tagcoll;

std::string PkgIdx::componentName() { return "PkgIdx"; }

time_t PkgIdx::computeTimestamp()
{
	return utils::Path::timestamp(utils::Path::pkgidx());
}

void PkgIdx::init(Cache& c)
{
	m_timestamp = computeTimestamp();

	Updater::updatePkgIdx();

	mastermmap.init(utils::Path::pkgidx());
	Tagcoll::MMapIndex::init(mastermmap, 0);
}


#ifdef COMPILE_TESTSUITE

#include <tests/test-utils.h>

namespace tut {

struct cache_component_debtags_pkgidx_shar {
    cache_component_debtags_pkgidx_shar() {
        aptInit();
        c.open( Cache::OpenDefault | Cache::OpenTags | Cache::OpenReadOnly );
    }
    Cache c;
};
TESTGRP(cache_component_debtags_pkgidx);

// Check that it can find the correct name for every package
template<> template<>
void to::test< 1 >()
{
	const PkgIdx& p = c.pkgidx();

	for (Packages::iterator i = c.packages().packagesBegin();
			i != c.packages().packagesEnd(); ++i)
		ensure_equals(i->name(), p.name(i->id()));
}

}

#endif

// vim:set ts=4 sw=4:
