/* -*- indent-tabs-mode: t; tab-width: 8; c-basic-offset: 8; -*- */

#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include "source.h"
#include "libburn.h"
#include "file.h"

/* main channel data can be padded on read, but 0 padding the subs will make
an unreadable disc */

int file_read(struct burn_source *source, unsigned char *buffer, int size)
{
	struct burn_source_file *fs = source->data;

	return read(fs->datafd, buffer, size);
}

int file_read_sub(struct burn_source *source, unsigned char *buffer, int size)
{
	struct burn_source_file *fs = source->data;

	return read(fs->subfd, buffer, size);
}

static void file_free(struct burn_source *source)
{
	struct burn_source_file *fs = source->data;

	close(fs->datafd);
	if (source->read_sub)
		close(fs->subfd);
	free(fs);
}

static int file_size(struct burn_source *source)
{
	struct stat buf;
	struct burn_source_file *fs = source->data;

	fstat(fs->datafd, &buf);
	return buf.st_size;
}

struct burn_source *burn_file_source_new(const char *path, const char *subpath)
{
	struct burn_source_file *fs;
	struct burn_source *src;
	int fd1, fd2 = 0;

	if (!path)
		return NULL;
	fd1 = open(path, O_RDONLY);
	if (fd1 == -1)
		return NULL;
	if (subpath) {
		fd2 = open(subpath, O_RDONLY);
		if (fd2 == -1) {
			close(fd1);
			return NULL;
		}
	}
	fs = malloc(sizeof(struct burn_source_file));
	fs->datafd = fd1;

	if (subpath)
		fs->subfd = fd2;

	src = burn_source_new();
	src->read = file_read;
	if (subpath)
		src->read_sub = file_read_sub;

	src->get_size = file_size;
	src->free_data = file_free;
	src->data = fs;
	return src;
}
