/* -*- indent-tabs-mode: t; tab-width: 8; c-basic-offset: 8; -*- */

#include "volume.h"
#include "util.h"
#include "tree.h"
#include <stdlib.h>
#include <string.h>

struct iso_volumeset *iso_volumeset_new(int volumeset_size,
					const char *volumeset_id,
					char *const *volume_id,
					const char *publisher_id,
					const char *data_preparer_id,
					time_t * expiration_time,
					time_t * effective_time)
{
	struct iso_volumeset *volset;
	int i;

	if (volumeset_size < 1)
		return NULL;

	volset = calloc(1, sizeof(struct iso_volumeset));
	volset->refcount = 1;

	volset->root = iso_tree_new_root(volset);

	volset->volumeset_id = iso_strdup(volumeset_id);
	volset->volumeset_size = volumeset_size;
	volset->publisher_id = iso_strdup(publisher_id);
	volset->data_preparer_id = iso_strdup(data_preparer_id);

	if (!expiration_time)
		volset->expiration_time = (time_t) - 1;
	else
		volset->expiration_time = *expiration_time;
	if (!effective_time)
		volset->effective_time = (time_t) - 1;
	else
		volset->effective_time = *effective_time;

	volset->volume_id = malloc(sizeof(char *) * volumeset_size);

	for (i = 0; i < volumeset_size; ++i) {
		volset->volume_id[i] =
			volume_id ? iso_strdup(volume_id[i]) : NULL;
	}

	/* default option values. these are pretty lenient :) but its up to
	   the app anyways */
	volset->options.iso_level = 2;
	volset->options.joliet = 1;

	return volset;
}

void iso_volumeset_free(struct iso_volumeset *volset)
{
	if (--volset->refcount < 1) {
		int i;

		iso_tree_free(volset->root);

		free(volset->volumeset_id);
		free(volset->publisher_id);
		free(volset->data_preparer_id);
		free(volset->copyright_file);
		free(volset->abstract_file);
		free(volset->bibliographic_file);

		for (i = 0; i < volset->volumeset_size; ++i)
			free(volset->volume_id[i]);
		free(volset->volume_id);

		free(volset->data_sectors);

		free(volset);
	}
}

struct iso_tree_dir **iso_volumeset_get_root(struct iso_volumeset *volumeset)
{
	return volumeset->root;
}

int iso_volumeset_get_iso_level(struct iso_volumeset *volumeset)
{
	return volumeset->options.iso_level;
}

void iso_volumeset_set_iso_level(struct iso_volumeset *volumeset, int level)
{
	if (level == 1 || level == 2)
		volumeset->options.iso_level = level;
}

int iso_volumeset_get_joliet(struct iso_volumeset *volumeset)
{
	return volumeset->options.joliet;
}

void iso_volumeset_set_joliet(struct iso_volumeset *volumeset, int joliet)
{
	volumeset->options.joliet = !!joliet;
}
