/***************************************************************************
 $RCSfile: ctreadertrader.h,v $
                             -------------------
    cvs         : $Id: ctreadertrader.h,v 1.3 2003/05/08 21:47:36 aquamaniac Exp $
    begin       : Wed Apr 23 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CTREADERTRADER_H
#define CTREADERTRADER_H

#include <chipcard/cterror.h>
#include <chipcard/ctreadercontext.h>


/**
 *
 */
class CTReaderTrader {
public:
  typedef enum {
    CallBackContinue=0,
    CallBackAbort
  } CallBackResult;

private:
  bool _next;
  unsigned int _readerFlags;
  unsigned int _readerFlagsMask;
  unsigned int _status;
  unsigned int _statusMask;
  unsigned int _statusDelta;
  int _requestid;

  int _responseLoop(int reqid, int maxloop);

protected:
  virtual CallBackResult callback(bool first);

public:
  CTReaderTrader(bool next=false,
		 unsigned int readerFlags=0,
		 unsigned int readerFlagsMask=0,
		 unsigned int status=0,
		 unsigned int statusMask=CHIPCARD_STATUS_LOCKED_BY_OTHER,
		 unsigned int statusDelta=0);
  virtual ~CTReaderTrader();

  virtual CTError start();
  virtual CTError stop();

  /**
   * @param timeout timeout in seconds (0=don't wait, -1=wait forever)
   */
  CTError getNext(CTReaderContext &tctx, int timeout);

  /**
   * This method checks whether another card is in the queue. If this
   * method successfully returns, @ref getNext will return an available card.
   * Otherwise there is no card. However, this method does ONE loop, so
   * all connections to all servers are at least checked once. The timeout
   * specified in the configuration file applies (usually about 750 ms).
   */
  CTError peekNext(int timeout=0);

};



#endif


