/***************************************************************************
                          artist.cpp  -  description
                             -------------------
    begin                : Sun Dec 23 2001
    copyright            : (C) 2001 by root
    email                : root@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dbmusic.h"
/* Put here so it's not automatically included by dbinit.h */
#include "dbmusicvalidator.h"

/** Adds new artist to the db.
 *
 * Returns error code.
 *@param ArtistInfo Pointer to the artist info struct.
 */
int dbMusic::addArtist(const ArtistInfo * const ar){
	if (ar->name.isEmpty())
		return ARTIST_ADD_FAIL;
	// truncate down the name so a match will appear (useful for very long names that are longer
	// than the db likes, which at 0.7.1 is 40 and shouldn't be changing.

	sqlstring="INSERT INTO artist (name,first,last,homepage,notes,follow) VALUES ('";
	sqlstring.append(validateQString(ar->name.left(40)));
	sqlstring.append("', ");
	sqlstring.append(validateNumQString(ar->first));
	sqlstring.append(", ");
	sqlstring.append(validateNumQString(ar->last));
	sqlstring.append(", '");
	sqlstring.append(validateQString(ar->homepage));
	sqlstring.append("', '");
	sqlstring.append(validateQString(ar->notes));
	sqlstring.append("', ");
	if (ar->follow)
		sqlstring.append("true");
	else
		sqlstring.append("false");
	sqlstring.append(")");
	cerr << "addArtist: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return ARTIST_ADD_FAIL;

	// now refill the artist qmap
	a=fillArtistQMap();
	if (!a)
		return a;
	return EVERYTHING_OK;

}
/** Deletes artist from the table.
 *
 * Returns error code.
 *@param QString artist name
 */
int dbMusic::deleteArtist(const QString &name){
	if (name.isEmpty())
		return ARTIST_DELETE_FAIL;

	// delete the artist. RI takes care of titles and tracks for us.
	sqlstring="DELETE FROM artist WHERE aid=";
	sqlstring.append(artist->find(name).data());
	cerr << "deleteArtist: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return ARTIST_DELETE_FAIL;

	// remove the item from the map
	artist->remove(name);
	return EVERYTHING_OK;
}
/** Fills a struct with a particular artist.
 *
 * Returns error code.
 *@param QString artist name
 *@param ArtistInfo struct to be filled
 */
int dbMusic::getArtist(const QString &fname, ArtistInfo *const ar){
	if (fname.isEmpty())
		return ARTIST_GET_FAIL;
	sqlstring="SELECT name,first,last,homepage,notes,follow FROM artist WHERE aid=";
	sqlstring.append(artist->find(fname).data());
	cerr << "getArtist: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return ARTIST_GET_FAIL;
	if (!Tuples())
		return NO_TUPLES;

	ar->name=GetValue(0,0);
	ar->first=GetValue(0,1);
	ar->last=GetValue(0,2);
	ar->homepage=GetValue(0,3);
	ar->notes=GetValue(0,4);
	ar->aid=artist->find(fname).data();
	QString t=GetValue(0,5);
	if (t=="t")
		ar->follow=true;
	else
		ar->follow=false;

	return EVERYTHING_OK;

}
/** Updates a particular artist.
 *
 * Returns error code
 *@param ArtistInfo Pointer to artist information.
 */
int dbMusic::updateArtist(const ArtistInfo *const ar){
	if (ar->name.isEmpty())
		return ARTIST_UPDATE_FAIL;;
	sqlstring="UPDATE artist SET name='";
	sqlstring.append(validateQString(ar->name));
	sqlstring.append("', first=");
	sqlstring.append(validateNumQString(ar->first));
	sqlstring.append(", last=");
	sqlstring.append(validateNumQString(ar->last));
	sqlstring.append(", homepage='");
	sqlstring.append(validateQString(ar->homepage));
	sqlstring.append("', notes='");
	sqlstring.append(validateQString(ar->notes));
	sqlstring.append("', follow=");
	if (ar->follow)
		sqlstring.append("true");
	else
		sqlstring.append("false");
	sqlstring.append(" WHERE aid=");
	sqlstring.append(validateNumQString(ar->aid));
	cerr << "updateArtist: " << sqlstring << endl;
	stat=Exec(sqlstring.local8Bit().data());
	if (execCheck() < 0)
		return ARTIST_UPDATE_FAIL;

	// first, find the data, then delete the key, then insert the new one.
	StringHashQMap::Iterator it;
	QString temp;
	for (it=artist->begin();it!=artist->end();it++)
	{
		if (it.data()==ar->aid)
		{
			// we for some reason cannot remove(it.key()). go figure. set a qstring to the value
			// then remove that.
			temp=it.key();
			artist->remove(temp);
			break;
		}
	}
	artist->insert(ar->name,ar->aid);
	return EVERYTHING_OK;

}
