/***************************************************************************
                          bfr.cpp  -  description
                             -------------------
    begin                : Sun Dec 23 2001
    copyright            : (C) 2001 by root
    email                : root@localhost.localdomain
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dbmusic.h"
/* Put here so it's not automatically included by dbinit.h */
#include "dbmusicvalidator.h"

/** Generates a dump file using pg_dump.
 *
 * Returns error code.
 *@param string name of file
 */
int dbMusic::backup(const QString &filename){
	cerr << "backup: removing file and opening." << endl;
	// open file for writing
	htmlrep= new QFile(validateFilename(filename));
	if (!htmlrep)
		return NO_MEMORY;
	if (htmlrep->exists())
		htmlrep->remove();
	if (!htmlrep->open(IO_WriteOnly))
		return FILE_OPEN_FAIL;
	s=new QTextStream(htmlrep);
	if (!s)
		return NO_MEMORY;

	cerr << "--------------backup: executing backup-----------------" << endl;
	// write create sequence and table
	QString temp;
	temp="CREATE SEQUENCE format_fid_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1;\n";
	temp.append("CREATE SEQUENCE genre_gid_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1;\n");
	temp.append("CREATE SEQUENCE label_lid_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1;\n");
	temp.append("CREATE SEQUENCE method_mid_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1;\n");
	temp.append("CREATE SEQUENCE type_tid_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1;\n");
	temp.append("CREATE SEQUENCE artist_aid_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1;\n");
	temp.append("CREATE SEQUENCE title_cdid_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1;\n");
	temp.append("CREATE SEQUENCE track_trackid_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1;\n");
	temp.append("CREATE SEQUENCE explore_eid_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1;\n");
	temp.append("CREATE SEQUENCE boxset_grpid_seq start 1 increment 1 maxvalue 2147483647 minvalue 1  cache 1; \n");
	s->writeRawBytes(temp.local8Bit().data(),temp.length());

	temp="\n\n\n";
	temp.append("CREATE TABLE format (fid integer DEFAULT nextval('format_fid_seq'::text) NOT NULL, name character varying(20) NOT NULL, Constraint format_pkey Primary Key (fid));\n");
	temp.append("CREATE TABLE genre (gid integer DEFAULT nextval('genre_gid_seq'::text) NOT NULL, name character varying(20) NOT NULL, Constraint genre_pkey Primary Key (gid));\n");
	temp.append("CREATE TABLE label (lid integer DEFAULT nextval('label_lid_seq'::text) NOT NULL, name character varying(20) NOT NULL, Constraint label_pkey Primary Key (lid));\n");
	temp.append("CREATE TABLE method (mid integer DEFAULT nextval('method_mid_seq'::text) NOT NULL, name character varying(20) NOT NULL, Constraint method_pkey Primary Key (mid));\n");
	temp.append("CREATE TABLE type (tid integer DEFAULT nextval('type_tid_seq'::text) NOT NULL, name character varying(20) NOT NULL, Constraint type_pkey Primary Key (tid));\n");
	temp.append("CREATE TABLE boxset (grpid integer DEFAULT nextval('boxset_grpid_seq'::text) NOT NULL, name character varying(40) NOT NULL, Constraint boxset_pkey Primary Key (grpid));\n");
	temp.append("CREATE TABLE explore (eid integer DEFAULT nextval('explore_eid_seq'::text) NOT NULL, name character varying(40) NOT NULL, Constraint explore_pkey Primary Key (eid));\n");
	temp.append("CREATE TABLE version (version character varying(10));\n");
	temp.append("CREATE TABLE artist (aid integer DEFAULT nextval('artist_aid_seq'::text) NOT NULL, follow boolean, notes character varying(2000), first smallint, last smallint, homepage character varying(60), name character varying(40) NOT NULL, Constraint artist_pkey Primary Key (aid));\n");
	temp.append("CREATE TABLE title (cdid integer DEFAULT nextval('title_cdid_seq'::text) NOT NULL, aid integer NOT NULL, fid integer NOT NULL DEFAULT 1, gid integer NOT NULL DEFAULT 1, lid integer NOT NULL DEFAULT 1, mid integer NOT NULL DEFAULT 1, tid integer NOT NULL DEFAULT 1, yearstart smallint, yearend smallint, nod smallint, notracks smallint, name character varying(55) NOT NULL, collected boolean, cdlen interval, grpid integer NOT NULL DEFAULT 1, notes character varying(2000), pic character varying(65), rating smallint, quality smallint, Constraint title_pkey Primary Key (cdid));\n");
	temp.append("CREATE TABLE track (trackid integer DEFAULT nextval('track_trackid_seq'::text) NOT NULL, cdid integer NOT NULL, name character varying(60) NOT NULL, length interval, Constraint track_pkey Primary Key (trackid));\n");
	temp.append("\n\n\n");
	s->writeRawBytes(temp.local8Bit().data(),temp.length());

	int a=backupTable("eid","explore");
	if (a<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}

	a=backupTable("fid","format");
	if (a<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}

	a=backupTable("gid","genre");
	if (a<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}

	a=backupTable("lid","label");
	if (a<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}

	a=backupTable("mid","method");
	if (a<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}

	a=backupTable("tid","type");
	if (a<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}

	a=backupTable("grpid","boxset");
	if (a<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}
	sqlstring="SELECT version FROM version";
	stat=Exec(sqlstring.local8Bit().data());
	if (stat<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}
	for (int i=0;i<Tuples();i++)
	{
		temp="INSERT INTO version VALUES ('";
		temp.append(validateQString(GetValue(i,0)));
		temp.append("');\n");
		s->writeRawBytes(temp.local8Bit().data(),temp.length());
	}
	s->writeRawBytes("\n\n\n",3);

	sqlstring="SELECT aid, follow, notes, first, last, homepage, name FROM artist";
	stat=Exec(sqlstring.local8Bit().data());
	if (stat<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}
	for (int i=0;i<Tuples();i++)
	{
		temp="INSERT INTO artist VALUES (";
		temp.append(validateQString(GetValue(i,0)));
		temp.append(", '");
		temp.append(validateQString(GetValue(i,1)));
		temp.append("', '");
		temp.append(validateQString(GetValue(i,2)));
		temp.append("', ");
		temp.append(validateQString(GetValue(i,3)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,4)));
		temp.append(", '");
		temp.append(validateQString(GetValue(i,5)));
		temp.append("', '");
		temp.append(validateQString(GetValue(i,6)));
		temp.append("');\n");
		s->writeRawBytes(temp.local8Bit().data(),temp.length());
		if (i%125==0)
			kapp->processEvents();
	}

	s->writeRawBytes("\n\n\n",3);
	sqlstring="SELECT cdid, aid, fid, gid, lid, mid, tid, yearstart, yearend, nod, notracks, name, collected, cdlen, grpid, notes, pic, rating, quality FROM title";
	stat=Exec(sqlstring.local8Bit().data());
	if (stat<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}
	for (int i=0;i<Tuples();i++)
	{
		temp="INSERT INTO title VALUES (";
		temp.append(validateQString(GetValue(i,0)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,1)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,2)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,3)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,4)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,5)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,6)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,7)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,8)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,9)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,10)));
		temp.append(", '");
		temp.append(validateQString(GetValue(i,11)));
		temp.append("', '");
		temp.append(validateQString(GetValue(i,12)));
		temp.append("', '");
		temp.append(validateQString(GetValue(i,13)));
		temp.append("', ");
		temp.append(validateQString(GetValue(i,14)));
		temp.append(", '");
		temp.append(validateQString(GetValue(i,15)));
		temp.append("', '");
		temp.append(validateQString(GetValue(i,16)));
		temp.append("', ");
		temp.append(validateQString(GetValue(i,17)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,18)));
		temp.append(");\n");
		s->writeRawBytes(temp.local8Bit().data(),temp.length());
		if (i%125==0)
			kapp->processEvents();
	}

	s->writeRawBytes("\n\n\n",3);
	sqlstring="SELECT trackid, cdid, name, length FROM track";
	stat=Exec(sqlstring.local8Bit().data());
	if (stat<0)
	{
		delete htmlrep;
		htmlrep=0;
		delete s;
		s=0;
		return stat;
	}
	for (int i=0;i<Tuples();i++)
	{
		temp="INSERT INTO track VALUES (";
		temp.append(validateQString(GetValue(i,0)));
		temp.append(", ");
		temp.append(validateQString(GetValue(i,1)));
		temp.append(", '");
		temp.append(validateQString(GetValue(i,2)));
		temp.append("', '");
		temp.append(validateQString(GetValue(i,3)));
		temp.append("');\n");
		s->writeRawBytes(temp.local8Bit().data(),temp.length());
		if (i%125==0)
			kapp->processEvents();
	}

	temp="\n\n\n";
	temp.append("CREATE INDEX ta_index ON title USING btree (aid);\n");
	temp.append("CREATE INDEX ttr_index ON track USING btree (cdid);\n");
	temp.append("\n\n\n");
	temp.append("ALTER TABLE title ADD CONSTRAINT title_aid_RI FOREIGN KEY (aid) REFERENCES artist(aid) ON UPDATE CASCADE ON DELETE CASCADE;\n");
	temp.append("ALTER TABLE title ADD CONSTRAINT title_fid_RI FOREIGN KEY (fid) REFERENCES format(fid) ON UPDATE CASCADE ON DELETE SET DEFAULT;\n");
	temp.append("ALTER TABLE title ADD CONSTRAINT title_gid_RI FOREIGN KEY (gid) REFERENCES genre(gid) ON UPDATE CASCADE ON DELETE SET DEFAULT;\n");
	temp.append("ALTER TABLE title ADD CONSTRAINT title_lid_RI FOREIGN KEY (lid) REFERENCES label(lid) ON UPDATE CASCADE ON DELETE SET DEFAULT;\n");
	temp.append("ALTER TABLE title ADD CONSTRAINT title_mid_RI FOREIGN KEY (mid) REFERENCES method(mid) ON UPDATE CASCADE ON DELETE SET DEFAULT;\n");
	temp.append("ALTER TABLE title ADD CONSTRAINT title_tid_RI FOREIGN KEY (tid) REFERENCES type(tid) ON UPDATE CASCADE ON DELETE SET DEFAULT;\n");
	temp.append("ALTER TABLE title ADD CONSTRAINT title_grpid_RI FOREIGN KEY (grpid) REFERENCES boxset(grpid) ON UPDATE CASCADE ON DELETE SET DEFAULT;\n");
	temp.append("ALTER TABLE track ADD CONSTRAINT track_cdid_RI FOREIGN KEY (cdid) REFERENCES title(cdid) ON UPDATE CASCADE ON DELETE CASCADE;\n");
	temp.append("\n\n\n");
	temp.append("SELECT SETVAL('boxset_grpid_seq',(SELECT MAX(grpid) FROM boxset));\n");
	temp.append("SELECT SETVAL('format_fid_seq',(SELECT MAX(fid) FROM format));\n");
	temp.append("SELECT SETVAL('genre_gid_seq',(SELECT MAX(gid) FROM genre));\n");
	temp.append("SELECT SETVAL('label_lid_seq',(SELECT MAX(lid) FROM label));\n");
	temp.append("SELECT SETVAL('method_mid_seq',(SELECT MAX(mid) FROM method));\n");
	temp.append("SELECT SETVAL('type_tid_seq',(SELECT MAX(tid) FROM type));\n");
	temp.append("SELECT SETVAL('boxset_grpid_seq',(SELECT MAX(grpid) FROM boxset));\n");
	temp.append("SELECT SETVAL('explore_eid_seq',(SELECT MAX(eid) FROM explore));\n");
	temp.append("SELECT SETVAL('artist_aid_seq',(SELECT MAX(aid) FROM artist));\n");
	temp.append("SELECT SETVAL('title_cdid_seq',(SELECT MAX(cdid) FROM title));\n");
	temp.append("SELECT SETVAL('track_trackid_seq',(SELECT MAX(trackid) FROM track));\n");
	s->writeRawBytes(temp.local8Bit().data(),temp.length());

	// close down and delete everything out.
	htmlrep->close();
	delete htmlrep;
	htmlrep=0;
	delete s;
	s=0;

	return EVERYTHING_OK;
}
/**
 * Support function for backup. Help reduce redundant code.
 *
 *@param QString id type
 *@param QString table name
 */
int dbMusic::backupTable(const QString &id, const QString &table){
	QString temp;
	sqlstring="SELECT ";
	sqlstring.append(id);
	sqlstring.append(" , name FROM ");
	sqlstring.append(table);
	stat=Exec(sqlstring.local8Bit().data());
	if (stat<0)
		return stat;
	for (int i=0;i<Tuples();i++)
	{
		temp="INSERT INTO ";
		temp.append(table);
		temp.append(" VALUES (");
		temp.append(validateQString(GetValue(i,0)));
		temp.append(", '");
		temp.append(validateQString(GetValue(i,1)));
		temp.append("');\n");
		s->writeRawBytes(temp.local8Bit().data(),temp.length());
		if (i%125==0)
			kapp->processEvents();
	}
	s->writeRawBytes("\n\n\n",3);

	return EVERYTHING_OK;
}
/**
 * "formats" the database out for use with dbMusic. It lays out all the basic tables, indexes, sequences,  and triggers for referential integrity.
 * Also adds a few basic entries to the categories. For more details, see dbmusic.dump or kmusicdb manual.
 *
 * Returns error code.
 *
 *@param string filename (usually kmusicdb.dump)
 */
int dbMusic::formatDb(){
	cerr << "formatDb: restore" << endl;
	QString file;
	file=(DBMUSIC_DATADIR);
	file.append(DATA_BASE);
	int stat=restore(validateFilename(file));
	if (stat<0)
		return stat;

	cerr << "formatDb: opti" << endl;
	stat=opti();
	if (stat<0)
		return stat;

	return EVERYTHING_OK;
}
/** Restores the db from a dump file (generated by pg_dump).
 *
 *@param string Filename to restore
 *
 * Returns error code.
 */
int dbMusic::restore(const QString &filename){
	cerr << "Restore Called: " << filename << endl;
	QString filestream, submits;

	// check for existance of file and open. do this first because we don't want to drop
	// tables and go uh-oh.
	htmlrep= new QFile(validateFilename(filename));
	if (!htmlrep)
		return NO_MEMORY;
	if (!htmlrep->open(IO_ReadOnly))
		return FILE_OPEN_FAIL;
	s=new QTextStream(htmlrep);
	if (!s)
		return NO_MEMORY;

	cerr << "restore: dropping tables" << endl;
	// first drop all the old data and sequences.
	// we dont care about these results because the db might be blank.
	// if there are errors, any below create's will fail.
	Exec("DROP TABLE track");
	Exec("DROP TABLE title");
	Exec("DROP TABLE artist");
	Exec("DROP TABLE genre");
	Exec("DROP TABLE label");
	Exec("DROP TABLE type");
	Exec("DROP TABLE method");
	Exec("DROP TABLE explore");
	Exec("DROP TABLE format");
	Exec("DROP TABLE boxset");
	Exec("DROP TABLE version");
	cerr << "restore: dropping sequences" << endl;
	Exec("DROP SEQUENCE artist_aid_seq");
	Exec("DROP SEQUENCE explore_eid_seq");
	Exec("DROP SEQUENCE format_fid_seq");
	Exec("DROP SEQUENCE label_lid_seq");
	Exec("DROP SEQUENCE method_mid_seq");
	Exec("DROP SEQUENCE type_tid_seq");
	Exec("DROP SEQUENCE genre_gid_seq");
	Exec("DROP SEQUENCE title_cdid_seq");
	Exec("DROP SEQUENCE track_trackid_seq");
	Exec("DROP SEQUENCE boxset_grpid_seq");

	cerr << "restore: launching restore process" << endl;
	// proc events to keep display updated, all the I/O is too intense
	kapp->processEvents();

	int i=0;
	stat=Exec("BEGIN WORK");
	if (stat<0)
	{
		return TABLE_FORMAT_FAIL;
		delete s;
		s=0;
		delete htmlrep;
		htmlrep=0;
	}
	while ( !(filestream=s->readLine()).isNull() )
	{
		if (i==25)
		{
			// in case of error, lets submit work every 125 inserts to reduce total failure. doesn't
			// case much of a slow
			Exec("END WORK");
			if (stat<0)
			{
				return TABLE_FORMAT_FAIL;
				delete s;
				s=0;
				delete htmlrep;
				htmlrep=0;
			}
			Exec("BEGIN WORK");
			kapp->processEvents();
			i=0;
		}

		// stuff to skip over
		if (filestream.left(2) == "--")
			continue;
		if (filestream.left(1) == "\\")
			continue;
		if (filestream=="")
			continue;

		// insert data into database
		submits.append(filestream);
		// we need a complete statment, so no ;, no Exec. append and continue
		if (filestream.find(";",-1) == -1)
			continue;

		stat=Exec(submits.local8Bit().data());
		//		cerr << "stat: " << stat << " readline: " << filestream << endl;
		if (stat==PGRES_FATAL_ERROR)
			i=24;
		submits="";
		i++;
	}
	stat=Exec("END WORK");
	if (stat<0)
	{
		return TABLE_FORMAT_FAIL;
		delete s;
		s=0;
		delete htmlrep;
		htmlrep=0;
	}

	delete s;
	s=0;
	delete htmlrep;
	htmlrep=0;

	cerr << "restore: done with process" << endl;
	// we are dealing with completely new data, so we must refill all the qmaps again.
	a=fillArtistQMap();
	if (a < 0)
		return a;
	a=fillQMap(KBOXSET);
	if (a<0)
		return a;
	a=fillQMap(KGENRE);
	if (a<0)
		return a;
	a=fillQMap(KLABEL);
	if (a<0)
		return a;
	a=fillQMap(KTYPE);
	if (a<0)
		return a;
	a=fillQMap(KMETHOD);
	if (a<0)
		return a;
	a=fillQMap(KFORMAT);
	if (a<0)
		return a;
	fillReverseQMap(KBOXSET);
	fillReverseQMap(KFORMAT);
	fillReverseQMap(KGENRE);
	fillReverseQMap(KLABEL);
	fillReverseQMap(KMETHOD);
	fillReverseQMap(KTYPE);
	cerr << "restore: done with maps" << endl;

	return EVERYTHING_OK;
}
