/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "flux.h"


void tt_stat_children_all(TT *root, u32 *count, u32 *size)
{
  TT *tt0;
  
  *count = 1;
  *size = 0;

  TT_FOR_ALL(root, tt0)
  {
    (*count)++;
    *size += tt_size(tt0);
  }
}


u32 tt_size_children(TT *root)
{
  TT *tt0;
  u32 size;

  size = 0;
  TT_FOR_EACH(root, tt0) size += tt_size(tt0);
  return(size);
}


u32 tt_size_children_all(TT *root)
{
  TT *tt0;
  u32 size;

  size = 0;
  TT_FOR_ALL(root, tt0) size += tt_size(tt0);
  return(size);
}


u32 tt_count_children(TT *tt)
{
  int num;

  for (num = 0, tt = tt_get_first_child(tt); tt; tt = tt_get_next(tt), num++) ;

  return(num);
}


u32 tt_count_children_all(TT *tt)
{
  int num;

  for (num = 0, tt = tt_get_first_child(tt); tt; tt = tt_get_next(tt), num++)
    if (tt_get_first_child(tt)) num += tt_count_children_all(tt);

  return(num);
}


u32 tt_count_siblings(TT *tt)
{
  TT *tt_parent;

  tt_parent = tt_get_parent(tt);
  if (tt_parent) return(tt_count_children(tt_parent));

  return(1);  /* Only self (am root node) */
}
