/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: IPService.cc,v 1.3 2001/12/19 12:46:46 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <fwbuilder/IPService.hh>
#include <fwbuilder/XMLTools.hh>

using namespace libfwbuilder;

const char *IPService::TYPENAME={"IPService"};

IPService::IPService() 
{
    setStr("protocol_num", "");
}

IPService::~IPService() {}

void IPService::fromXML(xmlNodePtr root)
{
    FWObject::fromXML(root);

    const char *n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("protocol_num")));
    assert(n!=NULL);
    setStr("protocol_num", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("fragm")));
    if(n!=NULL) setStr("fragm", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("short_fragm")));
    if(n!=NULL) setStr("short_fragm", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("lsrr")));
    if(n!=NULL) setStr("lsrr", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("ssrr")));
    if(n!=NULL) setStr("ssrr", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("rr")));
    if(n!=NULL) setStr("rr", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("ts")));
    if(n!=NULL) setStr("ts", n);
}








