/* arraylist.c generated by valac, the Vala compiler
 * generated from arraylist.vala, do not modify */

/* arraylist.vala
 *
 * Copyright (C) 2004-2005  Novell, Inc
 * Copyright (C) 2005  David Waite
 * Copyright (C) 2007-2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_BIDIR_ITERATOR (gee_bidir_iterator_get_type ())
#define GEE_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIterator))
#define GEE_IS_BIDIR_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_BIDIR_ITERATOR))
#define GEE_BIDIR_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_BIDIR_ITERATOR, GeeBidirIteratorIface))

typedef struct _GeeBidirIterator GeeBidirIterator;
typedef struct _GeeBidirIteratorIface GeeBidirIteratorIface;

#define GEE_TYPE_LIST_ITERATOR (gee_list_iterator_get_type ())
#define GEE_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIterator))
#define GEE_IS_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST_ITERATOR))
#define GEE_LIST_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST_ITERATOR, GeeListIteratorIface))

typedef struct _GeeListIterator GeeListIterator;
typedef struct _GeeListIteratorIface GeeListIteratorIface;

#define GEE_TYPE_ABSTRACT_LIST (gee_abstract_list_get_type ())
#define GEE_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractList))
#define GEE_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))
#define GEE_IS_ABSTRACT_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_LIST))
#define GEE_IS_ABSTRACT_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_LIST))
#define GEE_ABSTRACT_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_LIST, GeeAbstractListClass))

typedef struct _GeeAbstractList GeeAbstractList;
typedef struct _GeeAbstractListClass GeeAbstractListClass;
typedef struct _GeeAbstractListPrivate GeeAbstractListPrivate;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
typedef struct _GeeArrayListPrivate GeeArrayListPrivate;

#define GEE_ARRAY_LIST_TYPE_ITERATOR (gee_array_list_iterator_get_type ())
#define GEE_ARRAY_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIterator))
#define GEE_ARRAY_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorClass))
#define GEE_ARRAY_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR))
#define GEE_ARRAY_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_ARRAY_LIST_TYPE_ITERATOR))
#define GEE_ARRAY_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorClass))

typedef struct _GeeArrayListIterator GeeArrayListIterator;
typedef struct _GeeArrayListIteratorClass GeeArrayListIteratorClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GeeArrayListIteratorPrivate GeeArrayListIteratorPrivate;

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gboolean (*first) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
	GeeCollection* (*get_read_only_view) (GeeAbstractCollection* self);
};

struct _GeeBidirIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*previous) (GeeBidirIterator* self);
	gboolean (*has_previous) (GeeBidirIterator* self);
	gboolean (*last) (GeeBidirIterator* self);
};

struct _GeeListIteratorIface {
	GTypeInterface parent_iface;
	void (*set) (GeeListIterator* self, gconstpointer item);
	void (*insert) (GeeListIterator* self, gconstpointer item);
	void (*add) (GeeListIterator* self, gconstpointer item);
	gint (*index) (GeeListIterator* self);
};

struct _GeeListIface {
	GTypeInterface parent_iface;
	GeeListIterator* (*list_iterator) (GeeList* self);
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
	gpointer (*first) (GeeList* self);
	gpointer (*last) (GeeList* self);
	void (*insert_all) (GeeList* self, gint index, GeeCollection* collection);
	void (*sort) (GeeList* self, GCompareFunc compare_func);
	GeeList* (*get_read_only_view) (GeeList* self);
};

struct _GeeAbstractList {
	GeeAbstractCollection parent_instance;
	GeeAbstractListPrivate * priv;
};

struct _GeeAbstractListClass {
	GeeAbstractCollectionClass parent_class;
	GeeListIterator* (*list_iterator) (GeeAbstractList* self);
	gpointer (*get) (GeeAbstractList* self, gint index);
	void (*set) (GeeAbstractList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeAbstractList* self, gconstpointer item);
	void (*insert) (GeeAbstractList* self, gint index, gconstpointer item);
	gpointer (*remove_at) (GeeAbstractList* self, gint index);
	GeeList* (*slice) (GeeAbstractList* self, gint start, gint stop);
	gpointer (*first) (GeeAbstractList* self);
	gpointer (*last) (GeeAbstractList* self);
	void (*insert_all) (GeeAbstractList* self, gint index, GeeCollection* collection);
	GeeList* (*get_read_only_view) (GeeAbstractList* self);
};

struct _GeeArrayList {
	GeeAbstractList parent_instance;
	GeeArrayListPrivate * priv;
	gpointer* _items;
	gint _items_length1;
	gint __items_size_;
	gint _size;
};

struct _GeeArrayListClass {
	GeeAbstractListClass parent_class;
};

struct _GeeArrayListPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GEqualFunc _equal_func;
	gint _stamp;
};

struct _GeeArrayListIterator {
	GObject parent_instance;
	GeeArrayListIteratorPrivate * priv;
};

struct _GeeArrayListIteratorClass {
	GObjectClass parent_class;
};

struct _GeeArrayListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeArrayList* _list;
	gint _index;
	gboolean _removed;
	gint _stamp;
};


static gpointer gee_array_list_iterator_parent_class = NULL;
static GeeIteratorIface* gee_array_list_iterator_gee_iterator_parent_iface = NULL;
static GeeBidirIteratorIface* gee_array_list_iterator_gee_bidir_iterator_parent_iface = NULL;
static GeeListIteratorIface* gee_array_list_iterator_gee_list_iterator_parent_iface = NULL;
static gpointer gee_array_list_parent_class = NULL;

GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_abstract_collection_get_type (void) G_GNUC_CONST;
GType gee_bidir_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_iterator_get_type (void) G_GNUC_CONST;
GType gee_list_get_type (void) G_GNUC_CONST;
GType gee_abstract_list_get_type (void) G_GNUC_CONST;
GType gee_array_list_get_type (void) G_GNUC_CONST;
#define GEE_ARRAY_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_ARRAY_LIST, GeeArrayListPrivate))
enum  {
	GEE_ARRAY_LIST_DUMMY_PROPERTY,
	GEE_ARRAY_LIST_SIZE,
	GEE_ARRAY_LIST_EQUAL_FUNC,
	GEE_ARRAY_LIST_G_TYPE,
	GEE_ARRAY_LIST_G_DUP_FUNC,
	GEE_ARRAY_LIST_G_DESTROY_FUNC
};
GeeAbstractList* gee_abstract_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GEqualFunc gee_functions_get_equal_func_for (GType t);
static void gee_array_list_set_equal_func (GeeArrayList* self, GEqualFunc value);
GeeArrayList* gee_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeArrayList* gee_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
static GeeArrayListIterator* gee_array_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list);
static GeeArrayListIterator* gee_array_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list);
static GType gee_array_list_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GeeIterator* gee_array_list_real_iterator (GeeAbstractCollection* base);
static GeeListIterator* gee_array_list_real_list_iterator (GeeAbstractList* base);
gint gee_abstract_list_index_of (GeeAbstractList* self, gconstpointer item);
static gboolean gee_array_list_real_contains (GeeAbstractCollection* base, gconstpointer item);
GEqualFunc gee_array_list_get_equal_func (GeeArrayList* self);
static gint gee_array_list_real_index_of (GeeAbstractList* base, gconstpointer item);
static gpointer gee_array_list_real_get (GeeAbstractList* base, gint index);
static void gee_array_list_real_set (GeeAbstractList* base, gint index, gconstpointer item);
static void gee_array_list_grow_if_needed (GeeArrayList* self, gint new_count);
static gboolean gee_array_list_real_add (GeeAbstractCollection* base, gconstpointer item);
static void gee_array_list_shift (GeeArrayList* self, gint start, gint delta);
static void gee_array_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item);
gpointer gee_abstract_list_remove_at (GeeAbstractList* self, gint index);
static gboolean gee_array_list_real_remove (GeeAbstractCollection* base, gconstpointer item);
static gpointer gee_array_list_real_remove_at (GeeAbstractList* base, gint index);
static void gee_array_list_real_clear (GeeAbstractCollection* base);
gboolean gee_abstract_collection_add (GeeAbstractCollection* self, gconstpointer item);
gpointer gee_abstract_list_get (GeeAbstractList* self, gint index);
static GeeList* gee_array_list_real_slice (GeeAbstractList* base, gint start, gint stop);
gboolean gee_collection_get_is_empty (GeeCollection* self);
gint gee_collection_get_size (GeeCollection* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
static gboolean gee_array_list_real_add_all (GeeAbstractCollection* base, GeeCollection* collection);
void gee_tim_sort_sort_with_data (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list, GCompareDataFunc compare_data, void* compare_data_target);
void gee_array_list_sort_with_data (GeeArrayList* self, GCompareDataFunc compare, void* compare_target);
static void gee_array_list_set_capacity (GeeArrayList* self, gint value);
#define GEE_ARRAY_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_ARRAY_LIST_TYPE_ITERATOR, GeeArrayListIteratorPrivate))
enum  {
	GEE_ARRAY_LIST_ITERATOR_DUMMY_PROPERTY,
	GEE_ARRAY_LIST_ITERATOR_G_TYPE,
	GEE_ARRAY_LIST_ITERATOR_G_DUP_FUNC,
	GEE_ARRAY_LIST_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_array_list_iterator_real_next (GeeIterator* base);
static gboolean gee_array_list_iterator_real_has_next (GeeIterator* base);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static gboolean gee_array_list_iterator_real_first (GeeIterator* base);
static gpointer gee_array_list_iterator_real_get (GeeIterator* base);
static void gee_array_list_iterator_real_remove (GeeIterator* base);
static gboolean gee_array_list_iterator_real_previous (GeeBidirIterator* base);
static gboolean gee_array_list_iterator_real_has_previous (GeeBidirIterator* base);
static gboolean gee_array_list_iterator_real_last (GeeBidirIterator* base);
static void gee_array_list_iterator_real_set (GeeListIterator* base, gconstpointer item);
void gee_abstract_list_insert (GeeAbstractList* self, gint index, gconstpointer item);
static void gee_array_list_iterator_real_insert (GeeListIterator* base, gconstpointer item);
static void gee_array_list_iterator_real_add (GeeListIterator* base, gconstpointer item);
static gint gee_array_list_iterator_real_index (GeeListIterator* base);
static void gee_array_list_iterator_finalize (GObject* obj);
static void gee_array_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_array_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_array_list_finalize (GObject* obj);
static void gee_array_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_array_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length);



/**
 * Constructs a new, empty array list.
 *
 * If not provided, the function parameter is requested to the
 * {@link Functions} function factory methods.
 *
 * @param equal_func an optional element equality testing function
 */
#line 67 "arraylist.vala"
GeeArrayList* gee_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
#line 377 "arraylist.c"
	GeeArrayList * self;
#line 67 "arraylist.vala"
	self = (GeeArrayList*) gee_abstract_list_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
#line 67 "arraylist.vala"
	self->priv->g_type = g_type;
#line 67 "arraylist.vala"
	self->priv->g_dup_func = g_dup_func;
#line 67 "arraylist.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 68 "arraylist.vala"
	if (equal_func == NULL) {
#line 69 "arraylist.vala"
		equal_func = gee_functions_get_equal_func_for (g_type);
#line 391 "arraylist.c"
	}
#line 71 "arraylist.vala"
	gee_array_list_set_equal_func (self, equal_func);
#line 395 "arraylist.c"
	return self;
}


#line 67 "arraylist.vala"
GeeArrayList* gee_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func) {
#line 67 "arraylist.vala"
	return gee_array_list_construct (GEE_TYPE_ARRAY_LIST, g_type, g_dup_func, g_destroy_func, equal_func);
#line 404 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 77 "arraylist.vala"
static GeeIterator* gee_array_list_real_iterator (GeeAbstractCollection* base) {
#line 413 "arraylist.c"
	GeeArrayList * self;
	GeeIterator* result = NULL;
	self = (GeeArrayList*) base;
	result = (GeeIterator*) gee_array_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 78 "arraylist.vala"
	return result;
#line 420 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 84 "arraylist.vala"
static GeeListIterator* gee_array_list_real_list_iterator (GeeAbstractList* base) {
#line 429 "arraylist.c"
	GeeArrayList * self;
	GeeListIterator* result = NULL;
	self = (GeeArrayList*) base;
	result = (GeeListIterator*) gee_array_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
#line 85 "arraylist.vala"
	return result;
#line 436 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 91 "arraylist.vala"
static gboolean gee_array_list_real_contains (GeeAbstractCollection* base, gconstpointer item) {
#line 445 "arraylist.c"
	GeeArrayList * self;
	gboolean result = FALSE;
	self = (GeeArrayList*) base;
	result = gee_abstract_list_index_of ((GeeAbstractList*) self, item) != (-1);
#line 92 "arraylist.vala"
	return result;
#line 452 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 98 "arraylist.vala"
static gint gee_array_list_real_index_of (GeeAbstractList* base, gconstpointer item) {
#line 461 "arraylist.c"
	GeeArrayList * self;
	gint result = 0;
	self = (GeeArrayList*) base;
	{
		gint index;
#line 99 "arraylist.vala"
		index = 0;
#line 469 "arraylist.c"
		{
			gboolean _tmp0_;
#line 99 "arraylist.vala"
			_tmp0_ = TRUE;
#line 99 "arraylist.vala"
			while (TRUE) {
#line 99 "arraylist.vala"
				if (!_tmp0_) {
#line 99 "arraylist.vala"
					index++;
#line 480 "arraylist.c"
				}
#line 99 "arraylist.vala"
				_tmp0_ = FALSE;
#line 99 "arraylist.vala"
				if (!(index < self->_size)) {
#line 99 "arraylist.vala"
					break;
#line 488 "arraylist.c"
				}
#line 100 "arraylist.vala"
				if (gee_array_list_get_equal_func (self) (self->_items[index], item)) {
#line 492 "arraylist.c"
					result = index;
#line 101 "arraylist.vala"
					return result;
#line 496 "arraylist.c"
				}
			}
		}
	}
	result = -1;
#line 104 "arraylist.vala"
	return result;
#line 504 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 110 "arraylist.vala"
static gpointer gee_array_list_real_get (GeeAbstractList* base, gint index) {
#line 513 "arraylist.c"
	GeeArrayList * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeArrayList*) base;
#line 111 "arraylist.vala"
	g_assert (index >= 0);
#line 112 "arraylist.vala"
	g_assert (index < self->_size);
#line 522 "arraylist.c"
	result = (_tmp0_ = self->_items[index], ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 114 "arraylist.vala"
	return result;
#line 526 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 120 "arraylist.vala"
static void gee_array_list_real_set (GeeAbstractList* base, gint index, gconstpointer item) {
#line 535 "arraylist.c"
	GeeArrayList * self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (GeeArrayList*) base;
#line 121 "arraylist.vala"
	g_assert (index >= 0);
#line 122 "arraylist.vala"
	g_assert (index < self->_size);
#line 124 "arraylist.vala"
	self->_items[index] = (_tmp1_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), ((self->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->_items[index] = (self->priv->g_destroy_func (self->_items[index]), NULL)), _tmp1_);
#line 546 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 130 "arraylist.vala"
static gboolean gee_array_list_real_add (GeeAbstractCollection* base, gconstpointer item) {
#line 555 "arraylist.c"
	GeeArrayList * self;
	gboolean result = FALSE;
	gpointer _tmp2_;
	gpointer *_tmp1_;
	gconstpointer _tmp0_;
	self = (GeeArrayList*) base;
#line 131 "arraylist.vala"
	if (self->_size == self->_items_length1) {
#line 132 "arraylist.vala"
		gee_array_list_grow_if_needed (self, 1);
#line 566 "arraylist.c"
	}
#line 134 "arraylist.vala"
	_tmp1_ = &self->_items[self->_size++];
#line 134 "arraylist.vala"
	(*_tmp1_) = (_tmp2_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), (((*_tmp1_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp1_) = (self->priv->g_destroy_func ((*_tmp1_)), NULL)), _tmp2_);
#line 135 "arraylist.vala"
	self->priv->_stamp++;
#line 574 "arraylist.c"
	result = TRUE;
#line 136 "arraylist.vala"
	return result;
#line 578 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 142 "arraylist.vala"
static void gee_array_list_real_insert (GeeAbstractList* base, gint index, gconstpointer item) {
#line 587 "arraylist.c"
	GeeArrayList * self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (GeeArrayList*) base;
#line 143 "arraylist.vala"
	g_assert (index >= 0);
#line 144 "arraylist.vala"
	g_assert (index <= self->_size);
#line 146 "arraylist.vala"
	if (self->_size == self->_items_length1) {
#line 147 "arraylist.vala"
		gee_array_list_grow_if_needed (self, 1);
#line 600 "arraylist.c"
	}
#line 149 "arraylist.vala"
	gee_array_list_shift (self, index, 1);
#line 150 "arraylist.vala"
	self->_items[index] = (_tmp1_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), ((self->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->_items[index] = (self->priv->g_destroy_func (self->_items[index]), NULL)), _tmp1_);
#line 151 "arraylist.vala"
	self->priv->_stamp++;
#line 608 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 157 "arraylist.vala"
static gboolean gee_array_list_real_remove (GeeAbstractCollection* base, gconstpointer item) {
#line 617 "arraylist.c"
	GeeArrayList * self;
	gboolean result = FALSE;
	self = (GeeArrayList*) base;
	{
		gint index;
#line 158 "arraylist.vala"
		index = 0;
#line 625 "arraylist.c"
		{
			gboolean _tmp0_;
#line 158 "arraylist.vala"
			_tmp0_ = TRUE;
#line 158 "arraylist.vala"
			while (TRUE) {
#line 158 "arraylist.vala"
				if (!_tmp0_) {
#line 158 "arraylist.vala"
					index++;
#line 636 "arraylist.c"
				}
#line 158 "arraylist.vala"
				_tmp0_ = FALSE;
#line 158 "arraylist.vala"
				if (!(index < self->_size)) {
#line 158 "arraylist.vala"
					break;
#line 644 "arraylist.c"
				}
#line 159 "arraylist.vala"
				if (gee_array_list_get_equal_func (self) (self->_items[index], item)) {
#line 648 "arraylist.c"
					gpointer _tmp1_;
#line 160 "arraylist.vala"
					_tmp1_ = gee_abstract_list_remove_at ((GeeAbstractList*) self, index);
#line 652 "arraylist.c"
					((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
					result = TRUE;
#line 161 "arraylist.vala"
					return result;
#line 657 "arraylist.c"
				}
			}
		}
	}
	result = FALSE;
#line 164 "arraylist.vala"
	return result;
#line 665 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 170 "arraylist.vala"
static gpointer gee_array_list_real_remove_at (GeeAbstractList* base, gint index) {
#line 674 "arraylist.c"
	GeeArrayList * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	gpointer item;
	gpointer _tmp1_;
	self = (GeeArrayList*) base;
#line 171 "arraylist.vala"
	g_assert (index >= 0);
#line 172 "arraylist.vala"
	g_assert (index < self->_size);
#line 174 "arraylist.vala"
	item = (_tmp0_ = self->_items[index], ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 175 "arraylist.vala"
	self->_items[index] = (_tmp1_ = NULL, ((self->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->_items[index] = (self->priv->g_destroy_func (self->_items[index]), NULL)), _tmp1_);
#line 177 "arraylist.vala"
	gee_array_list_shift (self, index + 1, -1);
#line 179 "arraylist.vala"
	self->priv->_stamp++;
#line 693 "arraylist.c"
	result = item;
#line 180 "arraylist.vala"
	return result;
#line 697 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 186 "arraylist.vala"
static void gee_array_list_real_clear (GeeAbstractCollection* base) {
#line 706 "arraylist.c"
	GeeArrayList * self;
	self = (GeeArrayList*) base;
	{
		gint index;
#line 187 "arraylist.vala"
		index = 0;
#line 713 "arraylist.c"
		{
			gboolean _tmp0_;
#line 187 "arraylist.vala"
			_tmp0_ = TRUE;
#line 187 "arraylist.vala"
			while (TRUE) {
#line 720 "arraylist.c"
				gpointer _tmp1_;
#line 187 "arraylist.vala"
				if (!_tmp0_) {
#line 187 "arraylist.vala"
					index++;
#line 726 "arraylist.c"
				}
#line 187 "arraylist.vala"
				_tmp0_ = FALSE;
#line 187 "arraylist.vala"
				if (!(index < self->_size)) {
#line 187 "arraylist.vala"
					break;
#line 734 "arraylist.c"
				}
#line 188 "arraylist.vala"
				self->_items[index] = (_tmp1_ = NULL, ((self->_items[index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->_items[index] = (self->priv->g_destroy_func (self->_items[index]), NULL)), _tmp1_);
#line 738 "arraylist.c"
			}
		}
	}
#line 190 "arraylist.vala"
	self->_size = 0;
#line 191 "arraylist.vala"
	self->priv->_stamp++;
#line 746 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 197 "arraylist.vala"
static GeeList* gee_array_list_real_slice (GeeAbstractList* base, gint start, gint stop) {
#line 755 "arraylist.c"
	GeeArrayList * self;
	GeeList* result = NULL;
	GeeArrayList* slice;
	self = (GeeArrayList*) base;
#line 198 "arraylist.vala"
	g_return_val_if_fail (start <= stop, NULL);
#line 199 "arraylist.vala"
	g_return_val_if_fail (start >= 0, NULL);
#line 200 "arraylist.vala"
	g_return_val_if_fail (stop <= self->_size, NULL);
#line 202 "arraylist.vala"
	slice = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, gee_array_list_get_equal_func (self));
#line 768 "arraylist.c"
	{
		gint i;
#line 203 "arraylist.vala"
		i = start;
#line 773 "arraylist.c"
		{
			gboolean _tmp0_;
#line 203 "arraylist.vala"
			_tmp0_ = TRUE;
#line 203 "arraylist.vala"
			while (TRUE) {
#line 780 "arraylist.c"
				gpointer _tmp1_;
#line 203 "arraylist.vala"
				if (!_tmp0_) {
#line 203 "arraylist.vala"
					i++;
#line 786 "arraylist.c"
				}
#line 203 "arraylist.vala"
				_tmp0_ = FALSE;
#line 203 "arraylist.vala"
				if (!(i < stop)) {
#line 203 "arraylist.vala"
					break;
#line 794 "arraylist.c"
				}
#line 204 "arraylist.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) slice, _tmp1_ = gee_abstract_list_get ((GeeAbstractList*) self, i));
#line 798 "arraylist.c"
				((_tmp1_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp1_ = (self->priv->g_destroy_func (_tmp1_), NULL));
			}
		}
	}
	result = (GeeList*) slice;
#line 207 "arraylist.vala"
	return result;
#line 806 "arraylist.c"
}


/**
 * {@inheritDoc}
 */
#line 213 "arraylist.vala"
static gboolean gee_array_list_real_add_all (GeeAbstractCollection* base, GeeCollection* collection) {
#line 815 "arraylist.c"
	GeeArrayList * self;
	gboolean result = FALSE;
	self = (GeeArrayList*) base;
#line 213 "arraylist.vala"
	g_return_val_if_fail (collection != NULL, FALSE);
#line 214 "arraylist.vala"
	if (gee_collection_get_is_empty (collection)) {
#line 823 "arraylist.c"
		result = FALSE;
#line 215 "arraylist.vala"
		return result;
#line 827 "arraylist.c"
	}
#line 218 "arraylist.vala"
	gee_array_list_grow_if_needed (self, gee_collection_get_size (collection));
#line 831 "arraylist.c"
	{
		GeeIterator* _item_it;
#line 219 "arraylist.vala"
		_item_it = gee_iterable_iterator ((GeeIterable*) collection);
#line 219 "arraylist.vala"
		while (TRUE) {
#line 838 "arraylist.c"
			gpointer item;
			gpointer _tmp2_;
			gpointer *_tmp1_;
			gconstpointer _tmp0_;
#line 219 "arraylist.vala"
			if (!gee_iterator_next (_item_it)) {
#line 219 "arraylist.vala"
				break;
#line 847 "arraylist.c"
			}
#line 219 "arraylist.vala"
			item = gee_iterator_get (_item_it);
#line 220 "arraylist.vala"
			_tmp1_ = &self->_items[self->_size++];
#line 220 "arraylist.vala"
			(*_tmp1_) = (_tmp2_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), (((*_tmp1_) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*_tmp1_) = (self->priv->g_destroy_func ((*_tmp1_)), NULL)), _tmp2_);
#line 855 "arraylist.c"
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
#line 222 "arraylist.vala"
	self->priv->_stamp++;
#line 862 "arraylist.c"
	result = TRUE;
#line 223 "arraylist.vala"
	return result;
#line 866 "arraylist.c"
}


/**
 * Sorts items by comparing with the specified compare function.
 *
 * @deprecated This method has only been added as hack and will be
 * deprecated after the next odd minor version bump (>= 0.7.x).
 *
 * @param compare_func compare function to use to compare items
 */
#line 234 "arraylist.vala"
void gee_array_list_sort_with_data (GeeArrayList* self, GCompareDataFunc compare, void* compare_target) {
#line 234 "arraylist.vala"
	g_return_if_fail (self != NULL);
#line 235 "arraylist.vala"
	gee_tim_sort_sort_with_data (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, (GeeList*) self, compare, compare_target);
#line 884 "arraylist.c"
}


#line 238 "arraylist.vala"
static void gee_array_list_shift (GeeArrayList* self, gint start, gint delta) {
#line 238 "arraylist.vala"
	g_return_if_fail (self != NULL);
#line 239 "arraylist.vala"
	g_assert (start >= 0);
#line 240 "arraylist.vala"
	g_assert (start <= self->_size);
#line 241 "arraylist.vala"
	g_assert (start >= (-delta));
#line 243 "arraylist.vala"
	_vala_array_move (self->_items, sizeof (gpointer), start, start + delta, self->_size - start);
#line 245 "arraylist.vala"
	self->_size = self->_size + delta;
#line 902 "arraylist.c"
}


#line 248 "arraylist.vala"
static void gee_array_list_grow_if_needed (GeeArrayList* self, gint new_count) {
#line 908 "arraylist.c"
	gint minimum_size;
#line 248 "arraylist.vala"
	g_return_if_fail (self != NULL);
#line 249 "arraylist.vala"
	g_assert (new_count >= 0);
#line 251 "arraylist.vala"
	minimum_size = self->_size + new_count;
#line 252 "arraylist.vala"
	if (minimum_size > self->_items_length1) {
#line 918 "arraylist.c"
		gint _tmp0_ = 0;
#line 254 "arraylist.vala"
		if (new_count > self->_items_length1) {
#line 254 "arraylist.vala"
			_tmp0_ = minimum_size;
#line 924 "arraylist.c"
		} else {
#line 254 "arraylist.vala"
			_tmp0_ = 2 * self->_items_length1;
#line 928 "arraylist.c"
		}
#line 254 "arraylist.vala"
		gee_array_list_set_capacity (self, _tmp0_);
#line 932 "arraylist.c"
	}
}


#line 258 "arraylist.vala"
static void gee_array_list_set_capacity (GeeArrayList* self, gint value) {
#line 939 "arraylist.c"
	gint _tmp0_;
#line 258 "arraylist.vala"
	g_return_if_fail (self != NULL);
#line 259 "arraylist.vala"
	g_assert (value >= self->_size);
#line 261 "arraylist.vala"
	_tmp0_ = value;
#line 261 "arraylist.vala"
	self->_items = g_renew (gpointer, self->_items, value);
#line 261 "arraylist.vala"
	(_tmp0_ > self->_items_length1) ? memset (self->_items + self->_items_length1, 0, sizeof (gpointer) * (_tmp0_ - self->_items_length1)) : NULL;
#line 261 "arraylist.vala"
	self->_items_length1 = _tmp0_;
#line 953 "arraylist.c"
}


static gint gee_array_list_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeArrayList* self;
	self = (GeeArrayList*) base;
	result = self->_size;
#line 45 "arraylist.vala"
	return result;
#line 964 "arraylist.c"
}


GEqualFunc gee_array_list_get_equal_func (GeeArrayList* self) {
	GEqualFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_equal_func;
#line 51 "arraylist.vala"
	return result;
#line 974 "arraylist.c"
}


static void gee_array_list_set_equal_func (GeeArrayList* self, GEqualFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_equal_func = value;
	g_object_notify ((GObject *) self, "equal-func");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 272 "arraylist.vala"
static GeeArrayListIterator* gee_array_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list) {
#line 992 "arraylist.c"
	GeeArrayListIterator * self;
	GeeArrayList* _tmp0_;
#line 272 "arraylist.vala"
	g_return_val_if_fail (list != NULL, NULL);
#line 272 "arraylist.vala"
	self = (GeeArrayListIterator*) g_object_new (object_type, NULL);
#line 272 "arraylist.vala"
	self->priv->g_type = g_type;
#line 272 "arraylist.vala"
	self->priv->g_dup_func = g_dup_func;
#line 272 "arraylist.vala"
	self->priv->g_destroy_func = g_destroy_func;
#line 273 "arraylist.vala"
	self->priv->_list = (_tmp0_ = _g_object_ref0 (list), _g_object_unref0 (self->priv->_list), _tmp0_);
#line 274 "arraylist.vala"
	self->priv->_stamp = self->priv->_list->priv->_stamp;
#line 1009 "arraylist.c"
	return self;
}


#line 272 "arraylist.vala"
static GeeArrayListIterator* gee_array_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeArrayList* list) {
#line 272 "arraylist.vala"
	return gee_array_list_iterator_construct (GEE_ARRAY_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, list);
#line 1018 "arraylist.c"
}


#line 277 "arraylist.vala"
static gboolean gee_array_list_iterator_real_next (GeeIterator* base) {
#line 1024 "arraylist.c"
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
#line 278 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 279 "arraylist.vala"
	if ((self->priv->_index + 1) < self->priv->_list->_size) {
#line 280 "arraylist.vala"
		self->priv->_index++;
#line 281 "arraylist.vala"
		self->priv->_removed = FALSE;
#line 1036 "arraylist.c"
		result = TRUE;
#line 282 "arraylist.vala"
		return result;
#line 1040 "arraylist.c"
	}
	result = FALSE;
#line 284 "arraylist.vala"
	return result;
#line 1045 "arraylist.c"
}


#line 287 "arraylist.vala"
static gboolean gee_array_list_iterator_real_has_next (GeeIterator* base) {
#line 1051 "arraylist.c"
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
#line 288 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 1057 "arraylist.c"
	result = (self->priv->_index + 1) < self->priv->_list->_size;
#line 289 "arraylist.vala"
	return result;
#line 1061 "arraylist.c"
}


#line 292 "arraylist.vala"
static gboolean gee_array_list_iterator_real_first (GeeIterator* base) {
#line 1067 "arraylist.c"
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
#line 293 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 294 "arraylist.vala"
	if (gee_collection_get_size ((GeeCollection*) self->priv->_list) == 0) {
#line 1075 "arraylist.c"
		result = FALSE;
#line 295 "arraylist.vala"
		return result;
#line 1079 "arraylist.c"
	}
#line 297 "arraylist.vala"
	self->priv->_index = 0;
#line 298 "arraylist.vala"
	self->priv->_removed = FALSE;
#line 1085 "arraylist.c"
	result = TRUE;
#line 299 "arraylist.vala"
	return result;
#line 1089 "arraylist.c"
}


#line 302 "arraylist.vala"
static gpointer gee_array_list_iterator_real_get (GeeIterator* base) {
#line 1095 "arraylist.c"
	GeeArrayListIterator * self;
	gpointer result = NULL;
	gconstpointer _tmp0_;
	self = (GeeArrayListIterator*) base;
#line 303 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 304 "arraylist.vala"
	g_assert (self->priv->_index >= 0);
#line 305 "arraylist.vala"
	g_assert (self->priv->_index < self->priv->_list->_size);
#line 306 "arraylist.vala"
	g_assert (!self->priv->_removed);
#line 1108 "arraylist.c"
	result = (_tmp0_ = self->priv->_list->_items[self->priv->_index], ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
#line 307 "arraylist.vala"
	return result;
#line 1112 "arraylist.c"
}


#line 310 "arraylist.vala"
static void gee_array_list_iterator_real_remove (GeeIterator* base) {
#line 1118 "arraylist.c"
	GeeArrayListIterator * self;
	gpointer _tmp0_;
	self = (GeeArrayListIterator*) base;
#line 311 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 312 "arraylist.vala"
	g_assert (self->priv->_index >= 0);
#line 313 "arraylist.vala"
	g_assert (self->priv->_index < self->priv->_list->_size);
#line 314 "arraylist.vala"
	g_assert (!self->priv->_removed);
#line 315 "arraylist.vala"
	_tmp0_ = gee_abstract_list_remove_at ((GeeAbstractList*) self->priv->_list, self->priv->_index);
#line 1132 "arraylist.c"
	((_tmp0_ == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (_tmp0_ = (self->priv->g_destroy_func (_tmp0_), NULL));
#line 316 "arraylist.vala"
	self->priv->_index--;
#line 317 "arraylist.vala"
	self->priv->_removed = TRUE;
#line 318 "arraylist.vala"
	self->priv->_stamp = self->priv->_list->priv->_stamp;
#line 1140 "arraylist.c"
}


#line 321 "arraylist.vala"
static gboolean gee_array_list_iterator_real_previous (GeeBidirIterator* base) {
#line 1146 "arraylist.c"
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
#line 322 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 323 "arraylist.vala"
	if (self->priv->_index > 0) {
#line 324 "arraylist.vala"
		self->priv->_index--;
#line 1156 "arraylist.c"
		result = TRUE;
#line 325 "arraylist.vala"
		return result;
#line 1160 "arraylist.c"
	}
	result = FALSE;
#line 327 "arraylist.vala"
	return result;
#line 1165 "arraylist.c"
}


#line 330 "arraylist.vala"
static gboolean gee_array_list_iterator_real_has_previous (GeeBidirIterator* base) {
#line 1171 "arraylist.c"
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
#line 331 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 1177 "arraylist.c"
	result = (self->priv->_index - 1) >= 0;
#line 332 "arraylist.vala"
	return result;
#line 1181 "arraylist.c"
}


#line 335 "arraylist.vala"
static gboolean gee_array_list_iterator_real_last (GeeBidirIterator* base) {
#line 1187 "arraylist.c"
	GeeArrayListIterator * self;
	gboolean result = FALSE;
	self = (GeeArrayListIterator*) base;
#line 336 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 337 "arraylist.vala"
	if (gee_collection_get_size ((GeeCollection*) self->priv->_list) == 0) {
#line 1195 "arraylist.c"
		result = FALSE;
#line 338 "arraylist.vala"
		return result;
#line 1199 "arraylist.c"
	}
#line 340 "arraylist.vala"
	self->priv->_index = self->priv->_list->_size - 1;
#line 1203 "arraylist.c"
	result = TRUE;
#line 341 "arraylist.vala"
	return result;
#line 1207 "arraylist.c"
}


#line 344 "arraylist.vala"
static void gee_array_list_iterator_real_set (GeeListIterator* base, gconstpointer item) {
#line 1213 "arraylist.c"
	GeeArrayListIterator * self;
	gpointer _tmp1_;
	gconstpointer _tmp0_;
	self = (GeeArrayListIterator*) base;
#line 345 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 346 "arraylist.vala"
	g_assert (self->priv->_index >= 0);
#line 347 "arraylist.vala"
	g_assert (self->priv->_index < self->priv->_list->_size);
#line 348 "arraylist.vala"
	self->priv->_list->_items[self->priv->_index] = (_tmp1_ = (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), ((self->priv->_list->_items[self->priv->_index] == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->priv->_list->_items[self->priv->_index] = (self->priv->g_destroy_func (self->priv->_list->_items[self->priv->_index]), NULL)), _tmp1_);
#line 349 "arraylist.vala"
	self->priv->_stamp = self->priv->_list->priv->_stamp = self->priv->_list->priv->_stamp + 1;
#line 1228 "arraylist.c"
}


#line 352 "arraylist.vala"
static void gee_array_list_iterator_real_insert (GeeListIterator* base, gconstpointer item) {
#line 1234 "arraylist.c"
	GeeArrayListIterator * self;
	self = (GeeArrayListIterator*) base;
#line 353 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 354 "arraylist.vala"
	g_assert (self->priv->_index >= 0);
#line 355 "arraylist.vala"
	g_assert (self->priv->_index < self->priv->_list->_size);
#line 356 "arraylist.vala"
	gee_abstract_list_insert ((GeeAbstractList*) self->priv->_list, self->priv->_index, item);
#line 357 "arraylist.vala"
	self->priv->_index++;
#line 358 "arraylist.vala"
	self->priv->_stamp = self->priv->_list->priv->_stamp;
#line 1249 "arraylist.c"
}


#line 361 "arraylist.vala"
static void gee_array_list_iterator_real_add (GeeListIterator* base, gconstpointer item) {
#line 1255 "arraylist.c"
	GeeArrayListIterator * self;
	self = (GeeArrayListIterator*) base;
#line 362 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 363 "arraylist.vala"
	g_assert (self->priv->_index >= 0);
#line 364 "arraylist.vala"
	g_assert (self->priv->_index < self->priv->_list->_size);
#line 365 "arraylist.vala"
	gee_abstract_list_insert ((GeeAbstractList*) self->priv->_list, self->priv->_index + 1, item);
#line 366 "arraylist.vala"
	self->priv->_index++;
#line 367 "arraylist.vala"
	self->priv->_stamp = self->priv->_list->priv->_stamp;
#line 1270 "arraylist.c"
}


#line 370 "arraylist.vala"
static gint gee_array_list_iterator_real_index (GeeListIterator* base) {
#line 1276 "arraylist.c"
	GeeArrayListIterator * self;
	gint result = 0;
	self = (GeeArrayListIterator*) base;
#line 371 "arraylist.vala"
	g_assert (self->priv->_stamp == self->priv->_list->priv->_stamp);
#line 372 "arraylist.vala"
	g_assert (self->priv->_index >= 0);
#line 373 "arraylist.vala"
	g_assert (self->priv->_index < self->priv->_list->_size);
#line 1286 "arraylist.c"
	result = self->priv->_index;
#line 374 "arraylist.vala"
	return result;
#line 1290 "arraylist.c"
}


static void gee_array_list_iterator_class_init (GeeArrayListIteratorClass * klass) {
	gee_array_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeArrayListIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_array_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_array_list_iterator_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_array_list_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_array_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_array_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_array_list_iterator_real_next;
	iface->has_next = gee_array_list_iterator_real_has_next;
	iface->first = gee_array_list_iterator_real_first;
	iface->get = gee_array_list_iterator_real_get;
	iface->remove = gee_array_list_iterator_real_remove;
}


static void gee_array_list_iterator_gee_bidir_iterator_interface_init (GeeBidirIteratorIface * iface) {
	gee_array_list_iterator_gee_bidir_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->previous = gee_array_list_iterator_real_previous;
	iface->has_previous = gee_array_list_iterator_real_has_previous;
	iface->last = gee_array_list_iterator_real_last;
}


static void gee_array_list_iterator_gee_list_iterator_interface_init (GeeListIteratorIface * iface) {
	gee_array_list_iterator_gee_list_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->set = gee_array_list_iterator_real_set;
	iface->insert = gee_array_list_iterator_real_insert;
	iface->add = gee_array_list_iterator_real_add;
	iface->index = gee_array_list_iterator_real_index;
}


static void gee_array_list_iterator_instance_init (GeeArrayListIterator * self) {
	self->priv = GEE_ARRAY_LIST_ITERATOR_GET_PRIVATE (self);
	self->priv->_index = -1;
	self->priv->_removed = FALSE;
	self->priv->_stamp = 0;
}


static void gee_array_list_iterator_finalize (GObject* obj) {
	GeeArrayListIterator * self;
	self = GEE_ARRAY_LIST_ITERATOR (obj);
	_g_object_unref0 (self->priv->_list);
	G_OBJECT_CLASS (gee_array_list_iterator_parent_class)->finalize (obj);
}


static GType gee_array_list_iterator_get_type (void) {
	static volatile gsize gee_array_list_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_list_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayListIterator), 0, (GInstanceInitFunc) gee_array_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_bidir_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_bidir_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_list_iterator_info = { (GInterfaceInitFunc) gee_array_list_iterator_gee_list_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_array_list_iterator_type_id;
		gee_array_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeArrayListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
		g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_BIDIR_ITERATOR, &gee_bidir_iterator_info);
		g_type_add_interface_static (gee_array_list_iterator_type_id, GEE_TYPE_LIST_ITERATOR, &gee_list_iterator_info);
		g_once_init_leave (&gee_array_list_iterator_type_id__volatile, gee_array_list_iterator_type_id);
	}
	return gee_array_list_iterator_type_id__volatile;
}


static void gee_array_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeArrayListIterator * self;
	self = GEE_ARRAY_LIST_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_array_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeArrayListIterator * self;
	self = GEE_ARRAY_LIST_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ARRAY_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ARRAY_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ARRAY_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_array_list_class_init (GeeArrayListClass * klass) {
	gee_array_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeArrayListPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_array_list_real_iterator;
	GEE_ABSTRACT_LIST_CLASS (klass)->list_iterator = gee_array_list_real_list_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_array_list_real_contains;
	GEE_ABSTRACT_LIST_CLASS (klass)->index_of = gee_array_list_real_index_of;
	GEE_ABSTRACT_LIST_CLASS (klass)->get = gee_array_list_real_get;
	GEE_ABSTRACT_LIST_CLASS (klass)->set = gee_array_list_real_set;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_array_list_real_add;
	GEE_ABSTRACT_LIST_CLASS (klass)->insert = gee_array_list_real_insert;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_array_list_real_remove;
	GEE_ABSTRACT_LIST_CLASS (klass)->remove_at = gee_array_list_real_remove_at;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_array_list_real_clear;
	GEE_ABSTRACT_LIST_CLASS (klass)->slice = gee_array_list_real_slice;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add_all = gee_array_list_real_add_all;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_array_list_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_array_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_array_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_array_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_SIZE, "size");
	/**
	 * The elements' equality testing function.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_ARRAY_LIST_EQUAL_FUNC, g_param_spec_pointer ("equal-func", "equal-func", "equal-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_array_list_instance_init (GeeArrayList * self) {
	self->priv = GEE_ARRAY_LIST_GET_PRIVATE (self);
	self->_items = g_new0 (gpointer, 4);
	self->_items_length1 = 4;
	self->__items_size_ = self->_items_length1;
	self->priv->_stamp = 0;
}


static void gee_array_list_finalize (GObject* obj) {
	GeeArrayList * self;
	self = GEE_ARRAY_LIST (obj);
	self->_items = (_vala_array_free (self->_items, self->_items_length1, (GDestroyNotify) self->priv->g_destroy_func), NULL);
	G_OBJECT_CLASS (gee_array_list_parent_class)->finalize (obj);
}


/**
 * Resizable array implementation of the {@link List} interface.
 *
 * The storage array grows automatically when needed.
 *
 * This implementation is pretty good for rarely modified data. Because they are
 * stored in an array this structure does not fit for highly mutable data. For an
 * alternative implementation see {@link LinkedList}.
 *
 * @see LinkedList
 */
GType gee_array_list_get_type (void) {
	static volatile gsize gee_array_list_type_id__volatile = 0;
	if (g_once_init_enter (&gee_array_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeArrayListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_array_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeArrayList), 0, (GInstanceInitFunc) gee_array_list_instance_init, NULL };
		GType gee_array_list_type_id;
		gee_array_list_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_LIST, "GeeArrayList", &g_define_type_info, 0);
		g_once_init_leave (&gee_array_list_type_id__volatile, gee_array_list_type_id);
	}
	return gee_array_list_type_id__volatile;
}


static void gee_array_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeArrayList * self;
	self = GEE_ARRAY_LIST (object);
	switch (property_id) {
		case GEE_ARRAY_LIST_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_ARRAY_LIST_EQUAL_FUNC:
		g_value_set_pointer (value, gee_array_list_get_equal_func (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_array_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeArrayList * self;
	self = GEE_ARRAY_LIST (object);
	switch (property_id) {
		case GEE_ARRAY_LIST_EQUAL_FUNC:
		gee_array_list_set_equal_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_ARRAY_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_ARRAY_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_ARRAY_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static void _vala_array_move (gpointer array, gsize element_size, gint src, gint dest, gint length) {
	g_memmove (((char*) array) + (dest * element_size), ((char*) array) + (src * element_size), length * element_size);
	if (src < dest) {
		memset (((char*) array) + (src * element_size), 0, (dest - src) * element_size);
	} else {
		memset (((char*) array) + ((dest + length) * element_size), 0, (src - dest) * element_size);
	}
}




