/*
*****************************************************************************
   LIBGCP: extension internals

   Copyright (C) 2000-2001 Christoph Egger	[Christoph_Egger@t-online.de]

   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


*****************************************************************************
*/

#ifndef _GGI_GCP_INT_H
#define _GGI_GCP_INT_H

#include <ggi/internal/internal.h>
#include <ggi/gcp.h>


__BEGIN_DECLS

/* Exported variables */
#ifdef BUILDING_LIBGCP
extern ggi_extid    _gcpID;
#else
IMPORTVAR ggi_extid _gcpID;
#endif

__END_DECLS


/* Data types for the API functions */

#ifndef MIN
#define MIN(x,y)     (((x) < (y)) ? (x) : (y))
#define MAX(x,y)     (((x) > (y)) ? (x) : (y))
#define MID(x,y,z)   MAX((x), MIN((y), (z)))
#endif





/* Color palette manipulation
 */

/* RGBA */
typedef gcp_pixel (gcpfunc_MapRGBAColor)(ggi_visual_t vis, gcp_RGBAcolor *col);
typedef int (gcpfunc_UnmapRGBAPixel)(ggi_visual_t vis, gcp_pixel pixel, gcp_RGBAcolor *col);

typedef int (gcpfunc_PackRGBAColors)(ggi_visual_t vis,void *buf,gcp_RGBAcolor *cols,int len);
typedef int (gcpfunc_UnpackRGBAPixels)(ggi_visual_t vis,void *buf,gcp_RGBAcolor *cols,int len);
typedef int (gcpfunc_GetRGBAPalette)(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *cmap);
typedef int (gcpfunc_SetRGBAPalette)(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *cmap);


/* YUV */
typedef gcp_pixel (gcpfunc_MapYUVColor)(ggi_visual_t vis, gcp_YUVcolor *col);
typedef int (gcpfunc_UnmapYUVPixel)(ggi_visual_t vis, gcp_pixel pixel, gcp_YUVcolor *col);

typedef int (gcpfunc_PackYUVColors)(ggi_visual_t vis,void *buf,gcp_YUVcolor *cols,int len);
typedef int (gcpfunc_UnpackYUVPixels)(ggi_visual_t vis,void *buf,gcp_YUVcolor *cols,int len);

typedef int (gcpfunc_GetYUVPalette)(ggi_visual_t vis,int s,int len,gcp_YUVcolor *cmap);
typedef int (gcpfunc_SetYUVPalette)(ggi_visual_t vis,int s,int len,gcp_YUVcolor *cmap);


/* CMYK */
typedef gcp_pixel (gcpfunc_MapCMYKColor)(ggi_visual_t vis, gcp_CMYKcolor *col);
typedef int (gcpfunc_UnmapCMYKPixel)(ggi_visual_t vis, gcp_pixel pixel, gcp_CMYKcolor *col);

typedef int (gcpfunc_PackCMYKColors)(ggi_visual_t vis,void *buf,gcp_CMYKcolor *cols,int len);
typedef int (gcpfunc_UnpackCMYKPixels)(ggi_visual_t vis,void *buf,gcp_CMYKcolor *cols,int len);

typedef int (gcpfunc_GetCMYKPalette)(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *cmap);
typedef int (gcpfunc_SetCMYKPalette)(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *cmap);


/* HSV */
typedef gcp_pixel (gcpfunc_MapHSVColor)(ggi_visual_t vis, gcp_HSVcolor *col);
typedef int (gcpfunc_UnmapHSVPixel)(ggi_visual_t vis, gcp_pixel pixel, gcp_HSVcolor *col);

typedef int (gcpfunc_PackHSVColors)(ggi_visual_t vis,void *buf,gcp_HSVcolor *cols,int len);
typedef int (gcpfunc_UnpackHSVPixels)(ggi_visual_t vis,void *buf,gcp_HSVcolor *cols,int len);

typedef int (gcpfunc_GetHSVPalette)(ggi_visual_t vis,int s,int len,gcp_HSVcolor *cmap);
typedef int (gcpfunc_SetHSVPalette)(ggi_visual_t vis,int s,int len,gcp_HSVcolor *cmap);


/* Kodak PhotoCD */
typedef gcp_pixel (gcpfunc_MapYCCColor)(ggi_visual_t vis, gcp_YCCcolor *col);
typedef int (gcpfunc_UnmapYCCPixel)(ggi_visual_t vis, gcp_pixel pixel, gcp_YCCcolor *col);

typedef int (gcpfunc_PackYCCColors)(ggi_visual_t vis,void *buf,gcp_YCCcolor *cols,int len);
typedef int (gcpfunc_UnpackYCCPixels)(ggi_visual_t vis,void *buf,gcp_YCCcolor *cols,int len);

typedef int (gcpfunc_GetYCCPalette)(ggi_visual_t vis,int s,int len,gcp_YCCcolor *cmap);
typedef int (gcpfunc_SetYCCPalette)(ggi_visual_t vis,int s,int len,gcp_YCCcolor *cmap);



/* Gamma map manipulation
 */

/* RGBA */
typedef int (gcpfunc_GetRGBAGamma)(ggi_visual_t vis,ggi_float *r,ggi_float *g,ggi_float *b);
typedef int (gcpfunc_SetRGBAGamma)(ggi_visual_t vis,ggi_float r,ggi_float g,ggi_float b);

typedef int (gcpfunc_GetRGBAGammaMap)(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *gammamap);
typedef int (gcpfunc_SetRGBAGammaMap)(ggi_visual_t vis,int s,int len,gcp_RGBAcolor *gammamap);


/* YUV */
typedef int (gcpfunc_GetYUVGamma)(ggi_visual_t vis,ggi_float *y,ggi_float *u,ggi_float *v);
typedef int (gcpfunc_SetYUVGamma)(ggi_visual_t vis,ggi_float y,ggi_float u,ggi_float v);

typedef int (gcpfunc_GetYUVGammaMap)(ggi_visual_t vis,int s,int len,gcp_YUVcolor *gammamap);
typedef int (gcpfunc_SetYUVGammaMap)(ggi_visual_t vis,int s,int len,gcp_YUVcolor *gammamap);


/* CMYK */
typedef int (gcpfunc_GetCMYKGamma)(ggi_visual_t vis,ggi_float *c,ggi_float *m,ggi_float *y,ggi_float *k);
typedef int (gcpfunc_SetCMYKGamma)(ggi_visual_t vis,ggi_float c,ggi_float m,ggi_float y,ggi_float k);

typedef int (gcpfunc_GetCMYKGammaMap)(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *gammamap);
typedef int (gcpfunc_SetCMYKGammaMap)(ggi_visual_t vis,int s,int len,gcp_CMYKcolor *gammamap);


/* HSV */
typedef int (gcpfunc_GetHSVGamma)(ggi_visual_t vis,ggi_float *h,ggi_float *s,ggi_float *v);
typedef int (gcpfunc_SetHSVGamma)(ggi_visual_t vis,ggi_float h,ggi_float s,ggi_float v);

typedef int (gcpfunc_GetHSVGammaMap)(ggi_visual_t vis,int s,int len,gcp_HSVcolor *gammamap);
typedef int (gcpfunc_SetHSVGammaMap)(ggi_visual_t vis,int s,int len,gcp_HSVcolor *gammamap);


/* Kodak PhotoCD */
typedef int (gcpfunc_GetYCCGamma)(ggi_visual_t vis,ggi_float *y,ggi_float *c1,ggi_float *c2);
typedef int (gcpfunc_SetYCCGamma)(ggi_visual_t vis,ggi_float y,ggi_float c1,ggi_float c2);

typedef int (gcpfunc_GetYCCGammaMap)(ggi_visual_t vis,int s,int len,gcp_YCCcolor *gammamap);
typedef int (gcpfunc_SetYCCGammaMap)(ggi_visual_t vis,int s,int len,gcp_YCCcolor *gammamap);



/* Blending manipulation
 */

/* Color blending */
typedef gcp_pixel (gcpfunc_BlendColor)(ggi_visual_t vis, const gcp_pixel *pix1, const gcp_pixel *pix2, uint16 alpha);


/* Luminance manipulation
 */

typedef ggi_float (gcpfunc_GetLuminance)(ggi_visual_t vis, const gcp_pixel pix);


/* Lightness manipulation
 */

typedef gcp_pixel (gcpfunc_SetIntensity)(ggi_visual_t vis, const gcp_pixel *pix1, const gcp_pixel *light_color);
typedef gcp_pixel (gcpfunc_GetIntensity)(ggi_visual_t vis, const gcp_pixel *pix1, const gcp_pixel *pix2);






typedef struct gcppriv {
	/* Color palette manipulation
	 */

	/* RGBA */
	gcpfunc_MapRGBAColor		*MapRGBAColor;
	gcpfunc_UnmapRGBAPixel		*UnmapRGBAPixel;

	gcpfunc_PackRGBAColors		*PackRGBAColors;
	gcpfunc_UnpackRGBAPixels	*UnpackRGBAPixels;
	gcpfunc_GetRGBAPalette		*GetRGBAPalette;
	gcpfunc_SetRGBAPalette		*SetRGBAPalette;


	/* YUV */
	gcpfunc_MapYUVColor		*MapYUVColor;
	gcpfunc_UnmapYUVPixel		*UnmapYUVPixel;

	gcpfunc_PackYUVColors		*PackYUVColors;
	gcpfunc_UnpackYUVPixels		*UnpackYUVPixels;

	gcpfunc_GetYUVPalette		*GetYUVPalette;
	gcpfunc_SetYUVPalette		*SetYUVPalette;


	/* CMYK */
	gcpfunc_MapCMYKColor		*MapCMYKColor;
	gcpfunc_UnmapCMYKPixel		*UnmapCMYKPixel;

	gcpfunc_PackCMYKColors		*PackCMYKColors;
	gcpfunc_UnpackCMYKPixels	*UnpackCMYKPixels;

	gcpfunc_GetCMYKPalette		*GetCMYKPalette;
	gcpfunc_SetCMYKPalette		*SetCMYKPalette;


	/* HSV */
	gcpfunc_MapHSVColor		*MapHSVColor;
	gcpfunc_UnmapHSVPixel		*UnmapHSVPixel;

	gcpfunc_PackHSVColors		*PackHSVColors;
	gcpfunc_UnpackHSVPixels		*UnpackHSVPixels;

	gcpfunc_GetHSVPalette		*GetHSVPalette;
	gcpfunc_SetHSVPalette		*SetHSVPalette;


	/* Kodak PhotoCD */
	gcpfunc_MapYCCColor		*MapYCCColor;
	gcpfunc_UnmapYCCPixel		*UnmapYCCPixel;

	gcpfunc_PackYCCColors		*PackYCCColors;
	gcpfunc_UnpackYCCPixels		*UnpackYCCPixels;

	gcpfunc_GetYCCPalette		*GetYCCPalette;
	gcpfunc_SetYCCPalette		*SetYCCPalette;


	/* Gamma map manipulation
	 */

	/* RGBA */
	gcpfunc_GetRGBAGamma		*GetRGBAGamma;
	gcpfunc_SetRGBAGamma		*SetRGBAGamma;

	gcpfunc_GetRGBAGammaMap		*GetRGBAGammaMap;
	gcpfunc_SetRGBAGammaMap		*SetRGBAGammaMap;


	/* YUV */
	gcpfunc_GetYUVGamma		*GetYUVGamma;
	gcpfunc_SetYUVGamma		*SetYUVGamma;

	gcpfunc_GetYUVGammaMap		*GetYUVGammaMap;
	gcpfunc_SetYUVGammaMap		*SetYUVGammaMap;


	/* CMYK */
	gcpfunc_GetCMYKGamma		*GetCMYKGamma;
	gcpfunc_SetCMYKGamma		*SetCMYKGamma;

	gcpfunc_GetCMYKGammaMap		*GetCMYKGammaMap;
	gcpfunc_SetCMYKGammaMap		*SetCMYKGammaMap;


	/* HSV */
	gcpfunc_GetHSVGamma		*GetHSVGamma;
	gcpfunc_SetHSVGamma		*SetHSVGamma;

	gcpfunc_GetHSVGammaMap		*GetHSVGammaMap;
	gcpfunc_SetHSVGammaMap		*SetHSVGammaMap;


	/* Kodak PhotoCD */
	gcpfunc_GetYCCGamma		*GetYCCGamma;
	gcpfunc_SetYCCGamma		*SetYCCGamma;

	gcpfunc_GetYCCGammaMap		*GetYCCGammaMap;
	gcpfunc_SetYCCGammaMap		*SetYCCGammaMap;



	/* Blending manipulation
	 */

	/* Color blending */
	gcpfunc_BlendColor		*BlendColor;


	/* Luminance manipulation
	 */

	gcpfunc_GetLuminance		*GetLuminance;


	/* Lightness manipulation
	 */

	gcpfunc_SetIntensity		*SetIntensity;
	gcpfunc_GetIntensity		*GetIntensity;




	/* Here sublibs can store visual specific private data.
	 * If you have more than one sublib (for each visual)
	 * that needs private data, just add more pointers or
	 * add the data fields directly in this structure.
	 */

	void *priv;

} gcppriv;



/* Used to access the gcppriv structure for a particular visual. */
#define LIBGGI_GCPEXT(vis) ((gcppriv *)LIBGGI_EXT((vis),_gcpID))



#endif /* _GGI_GCP_INT_H */
