/*
******************************************************************************

   LibGGIMisc implementation for "X" target -- Initialization.

   
  
   Copyright (c) Fri Mar  2 2001 by: 
	Brian S. Julin		bri@calyx.com

  
   
   Permission is hereby granted, free of charge, to any person obtaining a
   copy of this software and associated documentation files (the "Software"),
   to deal in the Software without restriction, including without limitation
   the rights to use, copy, modify, merge, publish, distribute, sublicense,
   and/or sell copies of the Software, and to permit persons to whom the
   Software is furnished to do so, subject to the following conditions:

   The above copyright notice and this permission notice shall be included in
   all copies or substantial portions of the Software.

   The above copyright notice applies to all files in this package, unless 
   explicitly stated otherwise in the file itself or in a file named COPYING 
   in the same directory as the file.

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
   THE AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
   IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
   CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.





******************************************************************************
*/

#include "xggimisc.h"

static int GGIopen(ggi_visual *vis, struct ggi_dlhandle *dlh,
		   const char *args, void *argptr, uint32 *dlret)
{
	GGIDPRINT("LibGGIMisc: GGIopen(%p, %p, %s, %p, %p) called for X_GGIMisc sublib\n",
	       vis, dlh, args ? args : "(NULL)", argptr, dlret);

	/*-* Initialize target-private data structure */

	/*-* Hook in target functions */

	/* These are not implemented for X target -- use failure drivers 
	LIBGGI_GGIMISCEXT(vis)->waitraypos = GGIMISC_X_WaitRayPos;
	LIBGGI_GGIMISCEXT(vis)->getraypos = GGIMISC_X_GetRayPos;
	*/
	LIBGGI_GGIMISCEXT(vis)->setsplitline = GGIMISC_X_SetSplitline;

        /*-* Apply initial values */

	*dlret = GGI_DL_EXTENSION;
	return 0;
}	/* GGIopen */


static int GGIclose(ggi_visual *vis, struct ggi_dlhandle *dlh)
{
	GGIDPRINT("LibGGIMisc: GGIdlclose(%p, %p) called for XGGIMisc sublib\n", vis, dlh);

	/*-* Free target-private structure */


	return 0;
}	/* GGIclose */


int GGIMISCdl_x_ggimisc(int func, void **funcptr)
{
	switch (func) {
	case GGIFUNC_open:
		*funcptr = GGIopen;
		return 0;

	case GGIFUNC_exit:
		*funcptr = NULL;
		return 0;

	case GGIFUNC_close:
		*funcptr = GGIclose;
		return 0;

	default:
		*funcptr = NULL;
	}	/* switch */
      
	return GGI_ENOTFOUND;
}	/* GGIMISCdl_X_ggimisc */

/* This should be included by exactly _one_ file in each sublib. */
#include <ggi/internal/ggidlinit.h>
