/* $Id: gic2c.c,v 1.3 2004/09/18 12:06:58 cegger Exp $ */
#include <stdio.h>

static void str2c(FILE *ostream,char *buffer) 
{
	while(*buffer) {
		switch(*buffer) {
			case '\a': fputs("\\a",ostream);break;
			case '\n': fputs("\\n",ostream);break;
			case '\r': fputs("\\r",ostream);break;
			case '\t': fputs("\\t",ostream);break;
			case '"' : fputs("\\\"",ostream);break;
			default:
				fputc(*buffer,ostream);
				break;
		}
		buffer++;
	}
}

int main(int argc,char **argv)
{
	FILE *input,*output;
	char buffer[1024];
	
	input=stdin;
	output=stdout;
	
	fputs("#include <stdio.h>\n\n",output);

	fputs("static char gic_default_config[]= {\n",output);
	while(!feof(input)) {
		if (NULL==fgets(buffer,sizeof(buffer),input)) break;
		fputs("\t\"",output);
		str2c  (output,buffer);
		fputs("\"\n",output);
	}

	fputs("};\n\n",output);

	fputs("size_t gicWriteDefaultConfig(FILE *outfile)\n",output);
	fputs("{\n",output);
	fputs("\treturn fwrite(gic_default_config,sizeof(gic_default_config)-1,1,outfile);\n",output);
	fputs("}\n",output);

	return 0;
}
