------------------------------------------------------------------------------
--                              G N A T L I B                               --
--                                                                          --
--                     Copyright (C) 2001-2015, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with GNATCOLL.Traces; use GNATCOLL.Traces;
with GNAT.IO;     use GNAT.IO;

procedure Traces1 is
   Me1 : GNATCOLL.Traces.Trace_Handle := Create ("MODULE1");
   Me2 : GNATCOLL.Traces.Trace_Handle := Create ("MODULE2", On);
   Me3 : GNATCOLL.Traces.Trace_Handle := Create ("MODULE3", Off);
   Me4 : GNATCOLL.Traces.Trace_Handle;
begin
   Parse_Config_File ("gnatdebug");

   --  No config file parsed => all streams go to stdout by default.
   --  All streams are disabled
   if Active (Me1) then
      Put_Line ("Error: streams should be disabled by default");
   end if;
   if not Active (Me2) then
      Put_Line ("Error: stream2 is explicitely set to On");
   end if;
   if Active (Me3) then
      Put_Line ("Error: stream3 is explicitely set to Off");
   end if;

   Trace (Me1, "Message 1");
   Trace (Me2, "Message 2");
   Trace (Me3, "Message 3");

   --  If another module redefines the same traces, overriding the
   --  status, we should change only the ones using the default status
   --  so that the order of elaboration of modules is irrelevant for traces

   Me1 := Create ("MODULE1", On);
   Me2 := Create ("MODULE2", Off);  --  No effect
   Me3 := Create ("MODULE3", On);   --  No effect

   if not Active (Me1) then
      Put_Line ("Error: stream1 was explicitely activated");
   end if;
   if not Active (Me2) then
      Put_Line ("Error: stream2 is explicitely set to On, can't override");
   end if;
   if Active (Me3) then
      Put_Line ("Error: stream3 is explicitely set to Off, can't override");
   end if;

   Trace (Me1, "Message 1");
   Trace (Me2, "Message 2");
   Trace (Me3, "Message 3");

   --  Explicitly changing activation status

   Set_Active (Me1, False);
   Set_Active (Me2, False);
   Set_Active (Me3, True);

   if Active (Me1) then
      Put_Line ("Error: stream1 was explicitely deactivated");
   end if;
   if Active (Me2) then
      Put_Line ("Error: stream2 was explicitely deactivated");
   end if;
   if not Active (Me3) then
      Put_Line ("Error: stream3 was explicitely activated");
   end if;

   --  Testing asserts

   Assert (Me3, False,
           Error_Message      => "Always False",
           Message_If_Success => "Assert succeeded",
           Raise_Exception    => False);
   Assert (Me3, True,
           Error_Message      => "Always False",
           Message_If_Success => "Assert succeeded",
           Raise_Exception    => False);

   --  Testing indentation, should apply to all streams

   Set_Active (Me1, True);
   Set_Active (Me2, True);

   Increase_Indent (Me1, "Increase indent");
   Trace (Me2, "Standard trace");
   Increase_Indent;
   Trace (Me3, "Another trace");
   Decrease_Indent;
   Trace (Me2, "Standard trace");
   Decrease_Indent (Me1);

   --  Redirecting to another stream

   Me4 := Create ("MODULE4", On, Stream => "&2");
   Trace (Me4, "To stderr ?");

   --  Dumping the current configuration

   New_Line;
   Show_Configuration (GNAT.IO.Put_Line'Access);

   --  Logging after finalizing the module

   Finalize;
   Trace (Me1, "After finalization");

end Traces1;
