/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <libgnomedb/gnome-db-icon-list.h>

#define PARENT_TYPE GNOME_TYPE_ICON_LIST

struct _GnomeDbIconListPrivate {
	GdaDataModel *model;
};

static void gnome_db_icon_list_class_init (GnomeDbIconListClass *klass);
static void gnome_db_icon_list_init (GnomeDbIconList *list, GnomeDbIconListClass *klass);
static void gnome_db_icon_list_set_property (GObject *object,
					     guint paramid,
					     const GValue *value,
					     GParamSpec *pspec);
static void gnome_db_icon_list_get_property (GObject *object,
					     guint param_id,
					     GValue *value,
					     GParamSpec *pspec);
static void gnome_db_icon_list_finalize (GObject *object);

enum {
	PROP_0,
	PROP_MODEL,
};

static GObjectClass *parent_class = NULL;

/*
 * GnomeDbIconList class implementation
 */

static void
gnome_db_icon_list_class_init (GnomeDbIconListClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	parent_class = g_type_class_peek_parent (klass);

	object_class->set_property = gnome_db_icon_list_set_property;
	object_class->get_property = gnome_db_icon_list_get_property;
	object_class->finalize = gnome_db_icon_list_finalize;

	/* add class properties */
	g_object_class_install_property (
		object_class, PROP_MODEL,
		g_param_spec_object ("model", NULL, NULL,
				     GDA_TYPE_DATA_MODEL,
				     (G_PARAM_READABLE | G_PARAM_WRITABLE)));
}

static void
gnome_db_icon_list_init (GnomeDbIconList *list, GnomeDbIconListClass *klass)
{
	g_return_if_fail (GNOME_DB_IS_ICON_LIST (list));

	/* allocate private structure */
	list->priv = g_new0 (GnomeDbIconListPrivate, 1);
	list->priv->model = NULL;
}

static void
gnome_db_icon_list_set_property (GObject *object,
				 guint param_id,
				 const GValue *value,
				 GParamSpec *pspec)
{
	GnomeDbIconList *list = (GnomeDbIconList *) object;

	g_return_if_fail (GNOME_DB_IS_ICON_LIST (list));

	switch (param_id) {
	case PROP_MODEL :
		gnome_db_icon_list_set_model (list,
					      GDA_DATA_MODEL (g_value_get_object (value)));
		break;
	default :
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, param_id, pspec);
		break;
	}
}

static void
gnome_db_icon_list_get_property (GObject *object,
				 guint param_id,
				 GValue *value,
				 GParamSpec *pspec)
{
	GnomeDbIconList *list = (GnomeDbIconList *) object;

	g_return_if_fail (GNOME_DB_IS_ICON_LIST (list));

	switch (param_id) {
	case PROP_MODEL :
		g_value_set_object (value, G_OBJECT (list->priv->model));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, param_id, pspec);
		break;
	}
}

static void
gnome_db_icon_list_finalize (GObject *object)
{
	GnomeDbIconList *list = (GnomeDbIconList *) object;

	g_return_if_fail (GNOME_DB_IS_ICON_LIST (list));

	/* free memory */
	if (GDA_IS_DATA_MODEL (list->priv->model)) {
		g_object_unref (G_OBJECT (list->priv->model));
		list->priv->model = NULL;
	}

	g_free (list->priv);
	list->priv = NULL;

	/* chain to parent class */
	parent_class->finalize (object);
}

GType
gnome_db_icon_list_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (GnomeDbIconListClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_db_icon_list_class_init,
			NULL,
			NULL,
			sizeof (GnomeDbIconList),
			0,
			(GInstanceInitFunc) gnome_db_icon_list_init
		};
		type = g_type_register_static (PARENT_TYPE, "GnomeDbIconList", &info, 0);
	}
	return type;
}

/**
 * gnome_db_icon_list_new
 * @icon_width: Width to use for the icons.
 *
 * Create a new #GnomeDbIconList widget, a scrollable icon list bound to
 * a GDA data model.
 *
 * Returns: the newly created widget.
 */
GtkWidget *
gnome_db_icon_list_new (guint icon_width)
{
	GnomeDbIconList *list;

	list = g_object_new (GNOME_DB_TYPE_ICON_LIST, NULL);
	return GTK_WIDGET (list);
}

/**
 * gnome_db_icon_list_set_model
 * @list: A #GnomeDbIconList widget.
 * @model: A #GdaDataModel containing the data to be displayed.
 *
 * Associate a data model with the given icon list widget.
 */
void
gnome_db_icon_list_set_model (GnomeDbIconList *list, GdaDataModel *model)
{
}
