/**
 * @file libgnurdf/attribute.h Attribute functions
 *
 * $Id: attribute.h,v 1.4 2001/08/23 08:51:22 chipx86 Exp $
 *
 * @Copyright (C) 1999-2001 The GNUpdate Project.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */
#ifndef _LIBGNURDF_ATTRIBUTES_H_
#define _LIBGNURDF_ATTRIBUTES_H_

#include <libgnurdf/types.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Sets an element's attribute.
 * 
 * @param element The element containing the attribute.
 * @param attname The name of the attribute.
 * @param value   The attribute's value.
 */
void rdfSetAttribute(RdfElement *element, const char *attname,
					 const char *value);

/**
 * Returns an attribute's value.
 *
 * Note: The returned attribute must be freed.
 *
 * @param element The element containing the attribute.
 * @param attname The name of the attribute.
 *
 * @return The value of the attribute.
 */
char *rdfGetAttribute(RdfElement *element, const char *attname);

/**
 * Sets the value of an attribute in the specified namespace.
 * 
 * @param element The element containing the attribute.
 * @param attname The name of the attribute.
 * @param value   The attribute's value.
 * @param ns      The namespace of the attribute.
 */
void rdfSetNsAttribute(RdfElement *element, const char *attname,
					   const char *value, RdfNamespace *ns);

/**
 * Returns the value of an attribute in the specified namespace.
 *
 * Note: The returned value must be freed.
 *
 * @param element The element containing the attribute.
 * @param attname The name of the attribute.
 * @param ns      The namespace of the attribute.
 *
 * @return The value of the attribute.
 */
char *rdfGetNsAttribute(RdfElement *element, const char *attname,
						RdfNamespace *ns);

#ifdef __cplusplus
}
#endif

#endif /* _LIBGNURDF_ATTRIBUTES_H_ */

