-----------------------------------------------------------------------
--          GtkAda - Ada95 binding for the Gimp Toolkit              --
--                                                                   --
--                     Copyright (C) 2000                            --
--        Emmanuel Briot, Joel Brobecker and Arnaud Charlet          --
--                                                                   --
-- This library is free software; you can redistribute it and/or     --
-- modify it under the terms of the GNU General Public               --
-- License as published by the Free Software Foundation; either      --
-- version 2 of the License, or (at your option) any later version.  --
--                                                                   --
-- This library is distributed in the hope that it will be useful,   --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of    --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details.                          --
--                                                                   --
-- You should have received a copy of the GNU General Public         --
-- License along with this library; if not, write to the             --
-- Free Software Foundation, Inc., 59 Temple Place - Suite 330,      --
-- Boston, MA 02111-1307, USA.                                       --
--                                                                   --
-----------------------------------------------------------------------

with Gtk.Extra.Plot_Data;  use Gtk.Extra.Plot_Data;
with Gtk.Enums;            use Gtk.Enums;

package body Gtk.Extra.Plot_Box is

   -------------
   -- Gtk_New --
   -------------

   procedure Gtk_New
     (Box         : out Gtk_Plot_Box;
      Orientation : Gtk.Enums.Gtk_Orientation) is
   begin
      Box := new Gtk_Plot_Box_Record;
      Initialize (Box, Orientation);
   end Gtk_New;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize
     (Box         : access Gtk_Plot_Box_Record'Class;
      Orientation : Gtk.Enums.Gtk_Orientation)
   is
      function Internal (Orientation : Gtk_Orientation) return System.Address;
      pragma Import (C, Internal, "gtk_plot_box_new");
   begin
      Set_Object (Box, Internal (Orientation));
   end Initialize;
end Gtk.Extra.Plot_Box;
