/*******************************************************************************************************************************************
 dnd.c

 simple compilation directives :
 c++ -Wno-multichar -O2 -o dnd `pkg-config --cflags libgtkol-1.2` dnd.c `pkg-config --libs libgtkol-1.2`

*******************************************************************************************************************************************/

#include "capplication.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoForm1 definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoForm1 : public CForm
{
	public :
		CDemoForm1 (CApplication *inOwner);
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoForm2 definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoForm2 : public CForm
{
	public :
		CDemoForm2 (CApplication *inOwner);
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// CDemoForm3 definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoForm3 : public CForm
{
	public :
		CDemoForm3 (CApplication *inOwner);
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// special treeview listener definition
//-----------------------------------------------------------------------------------------------------------------------------------------
class CDemoTreeViewListener : public CTreeViewListener
{
	// called on inDragged when inDragged is dropped on inReceiver; the gtkol ioTargeted control reflects wich control would
	// own the inDragged control if the ioDoDrop parameter is set to true and the expected gtkol hierarchy rules are respected
	virtual void OnDragDrop (CObject *inDragged, CObject *inReceiver, CObject *&ioTargeted, SInt16 &ioIndex, TPoint inRelativePoint,
				 Bool &ioDoDrop);
};

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CDemoForm1::CDemoForm1 (CApplication *inOwner)
	   :CForm      (inOwner)
{
	// set the form caption
	SetCaption (CString("Drag and Drop 1"));

	// set the form bounds (center the form over screen x)
	SetBounds  (TBounds ((CApplication::GetScreenSize().w-200)/2, 120, 210, 250));

	// the form is a drop site
	SetDropSite (true);

	// instanciate a treeview with the specified listener (default single string field value model consideration)
	CTreeView *TreeView = new CTreeView (this, _IFVString_, new CDemoTreeViewListener());

	// the treeview itself may be moved by drag and drop operations, it is a potential drop site (if it were not, the included 
	// treeview items would not be either)
	TreeView -> SetDraggable (true);
	TreeView -> SetDropSite	 (true);

	// instanciate some treeview items, each of them are draggable and dropsiteable
	CTreeViewItem *Item0  = new CTreeViewItem (TreeView, CItemFieldValues (1, new CItemFieldValueString (CString("Item 0"))));
	Item0  -> SetDraggable (true);
	Item0  -> SetDropSite  (true);
	CTreeViewItem *Item1  = new CTreeViewItem (TreeView, CItemFieldValues (1, new CItemFieldValueString (CString("Item 1"))));
	Item1  -> SetDraggable (true);
	Item1  -> SetDropSite  (true);
	CTreeViewItem *Item01 = new CTreeViewItem (Item0,    CItemFieldValues (1, new CItemFieldValueString (CString("Item 0-1"))));
	Item01 -> SetDraggable (true);
	Item01 -> SetDropSite  (true);
	CTreeViewItem *Item02 = new CTreeViewItem (Item0,    CItemFieldValues (1, new CItemFieldValueString (CString("Item 0-2"))));
	Item02 -> SetDraggable (true);
	Item02 -> SetDropSite  (true);
	CTreeViewItem *Item03 = new CTreeViewItem (Item0,    CItemFieldValues (1, new CItemFieldValueString (CString("Item 0-3"))));
	Item03 -> SetDraggable (true);
	Item03 -> SetDropSite  (true);
	CTreeViewItem *Item10 = new CTreeViewItem (Item1,    CItemFieldValues (1, new CItemFieldValueString (CString("Item 1-0"))));
	Item10 -> SetDraggable (true);
	Item10 -> SetDropSite  (true);
	CTreeViewItem *Item11 = new CTreeViewItem (Item1,    CItemFieldValues (1, new CItemFieldValueString (CString("Item 1-1"))));
	Item11 -> SetDraggable (true);
	Item11 -> SetDropSite  (true);
	CTreeViewItem *Item2  = new CTreeViewItem (TreeView, CItemFieldValues (1, new CItemFieldValueString (CString("Item 2"))));
	Item2  -> SetDraggable (true);
	Item2  -> SetDropSite  (true);

	// show the form
	Show ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CDemoForm2::CDemoForm2 (CApplication *inOwner)
	   :CForm      (inOwner)
{
	// set the form caption
	SetCaption (CString("Drag and Drop 2"));

	// set the form bounds 
	SetBounds  (TBounds (100, 180, 210, 250));

	// the form is a drop site	
	SetDropSite (true);

	// instanciate a treeview with the specified listener (default single string field value model consideration)
	CTreeView *TreeView = new CTreeView (this, _IFVString_, new CDemoTreeViewListener());

	// the treeview itself may be moved by drag and drop operations, it is a potential drop site (if it were not, the included 
	// treeview items would not be either)
	TreeView -> SetDraggable (true);
	TreeView -> SetDropSite	 (true);

	// instanciate some treeview items, each of them are draggable and dropsiteable
	CTreeViewItem *Item0  = new CTreeViewItem (TreeView, CItemFieldValues (1, new CItemFieldValueString (CString("Item A"))));
	Item0  -> SetDraggable (true);
	Item0  -> SetDropSite  (true);
	CTreeViewItem *Item1  = new CTreeViewItem (TreeView, CItemFieldValues (1, new CItemFieldValueString (CString("Item B"))));
	Item1  -> SetDraggable (true);
	Item1  -> SetDropSite  (true);

	// show the form
	Show ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CDemoForm3::CDemoForm3 (CApplication *inOwner)
	   :CForm      (inOwner)
{
	// set the form caption
	SetCaption (CString("Drag and Drop 3"));

	// set the form bounds
	SetBounds  (TBounds (740, 180, 210, 250));

	// instanciate a vertical layout
	CVBoxLayout *VBoxLayout = new CVBoxLayout (this);
	VBoxLayout -> SetHomogeneous (false);

	// the vertical layout is a drop site	
	VBoxLayout -> SetDropSite (true);

	// instanciate some buttons
	CButton *Button0 = new CButton (VBoxLayout);
	CButton *Button1 = new CButton (VBoxLayout);

	// the buttons are draggable
	Button0 -> SetDraggable (true);
	Button1 -> SetDraggable (true);

	// show the form
	Show ();
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// Treeview OnDragDrop event handler
//-----------------------------------------------------------------------------------------------------------------------------------------
void CDemoTreeViewListener::OnDragDrop (CObject *inDragged, CObject *inReceiver, CObject *&ioTargeted, SInt16 &ioIndex, 
					TPoint inRelativePoint, Bool &ioDoDrop)
{
	// as we defined the treeview and any of its owned items as draggable ones, the inDragged parameter may be the treeview itself 
	// or any of its owned items, so first of all check the instance type
	if (inDragged -> ClassIs (__metaclass(CTreeViewItem)))
	{
		// ok, the treeview item may be dropped on the treeview iself or any of the dropsiteable items, so check the ioTargeted type
		if (ioTargeted -> ClassIs (__metaclass(CTreeViewItem)))
		{
			// retreive our treeview item instances
			CTreeViewItem *inSrcItem = static_cast <CTreeViewItem *> (inDragged);
			CTreeViewItem *inDstItem = static_cast <CTreeViewItem *> (ioTargeted);

			// we could let the gtkol dnd engine perform the owner affectation according to the ioDoDrop parameter value,
			// anyway request it now
			inSrcItem -> SetOwner (inDstItem);

			// we did the owner affectation, so tell gtkol to not [re]do it itself
			ioDoDrop = false;
	
			// the purpose of the sample definition is to expand the owner item when dropped on, so perform a full expansion
			inDstItem -> Expand (true);
		}
		// may be the targeted instance is a treeview
		else if (ioTargeted -> ClassIs (__metaclass(CTreeView)))
		{
			// retreive the instances
			CTreeView     *inTreeView = static_cast <CTreeView     *> (ioTargeted);
			CTreeViewItem *inSrcItem  = static_cast <CTreeViewItem *> (inDragged);
			
			// we could let the gtkol dnd engine perform the owner affectation according to the ioDoDrop parameter value,
			// anyway request it now
			inSrcItem -> SetOwner (inTreeView);

			// we did the owner affectation, so tell gtkol to not [re]do it itself
			ioDoDrop = false;
	
			// the purpose of the sample definition is to expand the item when dropped, so perform a full expansion
			inSrcItem -> Expand (true);
		}
	}
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// execution entry point
//-----------------------------------------------------------------------------------------------------------------------------------------
int main (int argc, char **argv)
{
	// declare an application
	CApplication Application (argc, argv);

	// instanciate our forms
	new CDemoForm1 (&Application);
	new CDemoForm2 (&Application);
	new CDemoForm3 (&Application);

	// run the application
	Application.Run ();

	// ok
	return 0;
}
