/******************************************************************************************************************************************
 ctablelayout.h
 
 CClass	
 |--CSerialized
    |--CMetaModule
       |--CObject
          |--CComponent
   	     |--CControl
	        |--CWidget
		   |--CContainer
		      |--CLayout
			 |--CTableLayout




	!!!!!!!! SERIALIZATION PROCESS NOT FULLY SUPPORTED YET	!!!!!!!!
	!!!!!!!! PACK PROPERTIES NOT FULLY TESTED YET		!!!!!!!!




 Allow the programmer to arrange widgets in rows and columns, making it easy to align many widgets next to each other, horizontally and
 vertically. Defaults to a 2x2 homogeneous table until beeing explicitly modified.

 Because the programmer may pack the children widgets as needed in rows and columns, the gtkol components hierarchy list sequence order of
 the table layout's children may not reflect the table layout order, according to the programmer's choice. 

 If the table layout is a dropsite, there won't be no particular handling on the children widgets insertion but to pack the new child into
 the first 1x1 available box. Anyway, this specificity could be bypassed with a dragged widget listener that defines its own behaviour into
 the virtual CWidgetListener::OnDragDrop function definition by calling the CTableLayout::SetTablePack function in order to personnalize
 the drop pack properties.
******************************************************************************************************************************************/

#ifndef __CTABLELAYOUT_H__
#define __CTABLELAYOUT_H__

#include "clayout.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// ctablelayout xml serialization constants
//-----------------------------------------------------------------------------------------------------------------------------------------
// <ctablelayout rows="UInt16" cols="UInt16" homogeneous="bool">
// [ <ctablelayout-col spacing="UInt16"></ctablelayout-col> ]
// [ <ctablelayout-row spacing="UInt16"></ctablelayout-row> ]
//    ...
//   <ctablelayout-child left="UInt16" right="UInt16" top="UInt16" bottom="UInt16" xpadding="UInt16" ypadding="UInt16" 
//    xexpand="bool" xshrink="bool" xfill="bool" yexpand="bool" yshrink="bool" yfill="bool"></ctablelayout-child>
// [ <ctablelayout-child left="UInt16" right="UInt16" top="UInt16" bottom="UInt16" xpadding="UInt16" ypadding="UInt16" 
//    xexpand="bool" xshrink="bool" xfill="bool" yexpand="bool" yshrink="bool" yfill="bool"></ctablelayout-child> ]
//    ...
// </ctablelayout>
//-----------------------------------------------------------------------------------------------------------------------------------------
static CString XML_TABLELAYOUT_ELEMENT	 		("ctablelayout");
static CString XML_TABLELAYOUT_ATTR_ROWS		("rows");
static CString XML_TABLELAYOUT_ATTR_COLS		("cols");
static CString XML_TABLELAYOUT_ATTR_HOMOGENEOUS		("homogeneous");
static CString XML_TABLELAYOUT_COL_ELEMENT		("ctablelayout-col");
static CString XML_TABLELAYOUT_ROW_ELEMENT		("ctablelayout-row");
static CString XML_TABLELAYOUT_ATTR_SPACING		("spacing");
static CString XML_TABLELAYOUT_CHILD_ELEMENT		("ctablelayout-child");
static CString XML_TABLELAYOUT_ATTR_CHILD_LEFT		("left");
static CString XML_TABLELAYOUT_ATTR_CHILD_RIGHT		("right");
static CString XML_TABLELAYOUT_ATTR_CHILD_TOP		("top");
static CString XML_TABLELAYOUT_ATTR_CHILD_BOTTOM	("bottom");
static CString XML_TABLELAYOUT_ATTR_CHILD_XPADDING	("xpadding");
static CString XML_TABLELAYOUT_ATTR_CHILD_YPADDING	("ypadding");
static CString XML_TABLELAYOUT_ATTR_CHILD_XEXPAND	("xexpand");
static CString XML_TABLELAYOUT_ATTR_CHILD_YEXPAND	("yexpand");
static CString XML_TABLELAYOUT_ATTR_CHILD_XSHRINK	("xshrink");
static CString XML_TABLELAYOUT_ATTR_CHILD_YSHRINK	("yshrink");
static CString XML_TABLELAYOUT_ATTR_CHILD_XFILL		("xfill");
static CString XML_TABLELAYOUT_ATTR_CHILD_YFILL		("yfill");

//-----------------------------------------------------------------------------------------------------------------------------------------
// table child pack properties definition
//-----------------------------------------------------------------------------------------------------------------------------------------
struct TTablePack
{
	SInt32			m_Index;	// table layout child widget gtkol component index
	UInt16			m_L;		// left pack index
	UInt16			m_R;		// right pack index
	UInt16			m_T;		// top pack index
	UInt16			m_B;		// bottom pack index
	UInt16			m_XPad;		// x padding 
	UInt16			m_YPad;		// y padding
	SInt8			m_XOpt;		// x options (GTK_EXPAND|GTK_SHRINK|GTK_FILL)
	SInt8			m_YOpt;		// y options (GTK_EXPAND|GTK_SHRINK|GTK_FILL)

	bool operator ==	(const TTablePack &) const;
	bool operator !=	(const TTablePack &) const;

	TTablePack		(const SInt32=-1, const UInt16=0, const UInt16=1, const UInt16=0, const UInt16=1, 
				 const UInt16=0, const UInt16=0, const SInt8=GTK_EXPAND|GTK_SHRINK|GTK_FILL, 
				 const SInt8=GTK_EXPAND|GTK_SHRINK|GTK_FILL);
};

// define a buffer of packs
typedef TBuffer <TTablePack> TTablePacks;

//-----------------------------------------------------------------------------------------------------------------------------------------
// CTableLayout class
//-----------------------------------------------------------------------------------------------------------------------------------------
class CTableLayout : public CLayout
{
	// instanciation section
	public :

		CTableLayout			(CContainer *inOwner=NULL, const CWidgetListener *inListener=NULL);
		virtual ~CTableLayout		();

	// protected widget requests handling
	protected :

		// gtk widget instanciation and initialization handling
		virtual GtkWidget *		PerformWidgetInstanciate	();
		virtual void			PerformWidgetInitialize		();

	// container specific protected functions redefinition
	protected :

		// specific container children add and remove request handling
		virtual void			PerformContainerAdd		(CWidget *inChild);
		virtual void			PerformContainerRemove		(CWidget *inChild);

	// CContainer and CLayout redefinition
	public :

		// get the container children number handling left, based on rows*cols max with special pack properties handling
		virtual SInt16			GetGtkChildrenNumberLeft	() const;

		// get the in table potential drop index for the potential child : returns -1 always, keep in mind that the gui packed
		// widgets list and the direct children gtkol hierarchy may differ; the children are always appended at the end of the
		// gtkol children list while the gui and pack properties may specify an alternat placement
		virtual SInt16			GetDropIndexAtPoint		(const TPoint &inRelativePoint, 
										 const CControl *inCandidate) const;
	// table layout specifics
	public :

		// table layout columns and rows number access
		virtual void			SetTableSize			(const UInt16 inRows, const UInt16 inCols);
		UInt16				GetTableRows			() const;
		UInt16				GetTableCols			() const;

		// set the table properties for the next child packing, the inLeft, inRight, inTop and inBottom fields specify the row and
		// column numbers which make up the invisible rectangle that the child widget is packed into. inXPad and inYPad specify the
		// space between this widget and the surrounding table cells
		virtual void			SetTablePack			(const UInt16 inLeft, const UInt16 inRight, 
										 const UInt16 inTop,  const UInt16 inBottom,
										 const UInt16 inXPad=0, const UInt16 inYPad=0,
										 const SInt8  inXOpt=GTK_EXPAND|GTK_SHRINK|GTK_FILL,
										 const SInt8  inYOpt=GTK_EXPAND|GTK_SHRINK|GTK_FILL);

		// get the table pack properties of the specified child widget / get the whole table packs
		const TTablePack *		GetTablePack			(const CWidget *inChild) const;
		TTablePacks			GetTablePacks			() const;

		// get the table pack point as indices from the specified table layout relative coord point i.e. returns left and top
		// attributes of the associated pack table structure
		TPoint				GetTablePackFromPoint		(const TPoint &inRelativePoint) const;

		// controlling whether or not all children are given equal space in the boxes
		virtual void			SetHomogeneous			(const bool inHomogeneous);
		bool				GetHomogeneous			() const;

		// specified column and row spacing access
		virtual void			SetColSpacing			(const UInt16 inCol, const UInt16 inSpacing);
		UInt16				GetColSpacing			(const UInt16 inCol) const;
		virtual void			SetRowSpacing			(const UInt16 inRow, const UInt16 inSpacing);
		UInt16				GetRowSpacing			(const UInt16 inRow) const;

	// CSerialized redefinition
	public :

		// table layout specific xml serialization
		virtual void			Serialize			(CXMLElementNode *&ioXMLElementNode, const int inMode) 
										 THROWABLE;
	// protected attributes
	protected :

		// rows and columns number
		UInt16				m_Rows;
		UInt16				m_Cols;

		// the list of child pack properties and the associated used/empty packs bytes image
		TTablePacks			m_TablePacks;
		TBuffer <TBuffer <SInt8> >	m_Packs;

		// internal service, get the pack record to be considered for the potential specified child, works directly on the 
		// m_TablePacks protected attribute to prepare default pack properties until explicitly affected by SetTablePack function
		TTablePack * 			GetTablePackFor 		(const CWidget *inWidget =NULL);

		// get the pack size in rows*cols of the specified child, get the total packs size
		UInt16				GetTablePackSize		(const UInt32) const;
		UInt16				GetTablePackTotalSize		() const;

		// table layout metaclass association
		SECTION_DYNAMIC_METACLASS;
};

// metaclass and class tag declaration
DECLARE_DYNAMIC_METACLASS ('tble', CTableLayout, CLayout);

#endif
