/*******************************************************************************************************************************************
 ccontrol.c
*******************************************************************************************************************************************/

#include "ccontrol.h"

//-----------------------------------------------------------------------------------------------------------------------------------------
// metaclass code resolution
//-----------------------------------------------------------------------------------------------------------------------------------------
RESOLVE_GENERIC_METACLASS (CControl);

//-----------------------------------------------------------------------------------------------------------------------------------------
// constructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CControl::CControl	    (CComponent *inOwner, const CObjectListener *inListener)
	 :CComponent	    (inOwner, inListener),
	  m_Draggable	    (false),
	  m_DropSite	    (false),
	  m_Bounds    	    (),
	  m_SerializeBounds (false),
	  m_SerializeDnD    (true)
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// destructor
//-----------------------------------------------------------------------------------------------------------------------------------------
CControl::~CControl ()
{ }

//-----------------------------------------------------------------------------------------------------------------------------------------
// control size and position affectation
//-----------------------------------------------------------------------------------------------------------------------------------------
void CControl::SetBounds (const TBounds &inBounds)
{
	m_Bounds = inBounds;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// control size and position access
//-----------------------------------------------------------------------------------------------------------------------------------------
TBounds CControl::GetBounds () const
{
	return m_Bounds;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// draggable propertie
//-----------------------------------------------------------------------------------------------------------------------------------------
void CControl::SetDraggable (const Bool inDraggable)
{
	m_Draggable = inDraggable;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// draggable propertie
//-----------------------------------------------------------------------------------------------------------------------------------------
Bool CControl::GetDraggable () const
{
	return m_Draggable;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// drop site propertie
//-----------------------------------------------------------------------------------------------------------------------------------------
void CControl::SetDropSite (const Bool inDropSite)
{
	m_DropSite = inDropSite;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// drop site propertie
//-----------------------------------------------------------------------------------------------------------------------------------------
Bool CControl::GetDropSite () const
{
	return m_DropSite;
}

//-----------------------------------------------------------------------------------------------------------------------------------------
// control serialization
//-----------------------------------------------------------------------------------------------------------------------------------------
void CControl::Serialize (CXMLElementNode *&ioXMLElementNode, const int inMode) THROWABLE
{
	// generic component serialization call
	CComponent::Serialize (ioXMLElementNode, inMode);

	// serialization request analyse
	switch (inMode)
	{
		// serialization dump
		case XML_WRITE :
		{
			// instanciate a new xml element to store the ccontrol attributes
			CXMLElement *XMLElement = new CXMLElement (ioXMLElementNode, XML_CONTROL_ELEMENT);

			// set the newly allocated xml element attributes
			if (m_SerializeDnD)
			{
				XMLElement -> AddAttribute (XML_CONTROL_ATTRIBUTE_DRAGGABLE, CString(m_Draggable?"true":"false"));
				XMLElement -> AddAttribute (XML_CONTROL_ATTRIBUTE_DROPSITE,  CString(m_DropSite ?"true":"false"));
			}
			
			// serialize the bounds attribute only if explicitly requested on the derived definitions
			if (m_SerializeBounds)
			{
				XMLElement -> AddAttribute (XML_CONTROL_ATTRIBUTE_X, CString(m_Bounds.x));
				XMLElement -> AddAttribute (XML_CONTROL_ATTRIBUTE_Y, CString(m_Bounds.y));
				XMLElement -> AddAttribute (XML_CONTROL_ATTRIBUTE_W, CString(m_Bounds.w));
				XMLElement -> AddAttribute (XML_CONTROL_ATTRIBUTE_H, CString(m_Bounds.h));
			}

			// the component created a xml node referencing the potential children of this instance; to give the user a more
			// friendly presentation, keep the current control serialization before the children specifications that may grow
			// considerably; so reparent the concerned xml node at the end of the io one
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_COMPONENT_CHILDREN_ELEMENT);

			// check we got the node to reparent (it may not have been created by the generic call if there is no child at all)
			if (inXMLNode != NULL)
	
				// "reparent" it (it is already its parent), i.e. move it at the end of its current io xml node
				::xml_node_set_parent (ioXMLElementNode, inXMLNode);

			// modify the in/out element node pointer to reference the newly allocated xml node so that the serialization
			// process continues under our newly allocated xml node i.e. under the XML_CONTROL_ELEMENT definition
			ioXMLElementNode = XMLElement -> GetXMLElementNode ();
		}
		break;

		// serialiation load
		case XML_READ :	
		{
			// get the current xml node interested child
			CXMLElementNode *inXMLNode = ::xml_node_get_child (ioXMLElementNode, XML_CONTROL_ELEMENT);

			// check we got an expected ccontrol node
			if (inXMLNode == NULL)
				throw new CException (CString("CControl::Serialize, specified xml node is not a \"") + 
							      XML_CONTROL_ELEMENT + CString("\" element one."), __exception(XMLPARSE));

			// modify the in/out element node pointer so that the serialization process will continue under the ccontrol node
			ioXMLElementNode = inXMLNode;

			// set the control properties from the expected xml node attributes values
			if (m_SerializeDnD)
			{
				SetDraggable (::xml_node_get_attribute (inXMLNode, XML_CONTROL_ATTRIBUTE_DRAGGABLE).GetValue().ToBool());
				SetDropSite  (::xml_node_get_attribute (inXMLNode, XML_CONTROL_ATTRIBUTE_DROPSITE ).GetValue().ToBool());
			}

			// hold on the bounds only if requested by the derived definitions
			if (m_SerializeBounds)
				SetBounds (TBounds (::xml_node_get_attribute (inXMLNode, XML_CONTROL_ATTRIBUTE_X).GetValue().ToLong(),
						    ::xml_node_get_attribute (inXMLNode, XML_CONTROL_ATTRIBUTE_Y).GetValue().ToLong(),
						    ::xml_node_get_attribute (inXMLNode, XML_CONTROL_ATTRIBUTE_W).GetValue().ToLong(),
						    ::xml_node_get_attribute (inXMLNode, XML_CONTROL_ATTRIBUTE_H).GetValue().ToLong()));
		}
		break;
	}
}



