/*  Inti: Integrated Foundation Classes
 *  Copyright (C) 2002-2003 The Inti Development Team.
 *
 *  celleditable.cc - GtkCellEditable C++ wrapper implementation
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "celleditable.h"
#include "private/celleditable_p.h"
#include "../glib/private/object_p.h"
#include "../gdk/events.h"
#include "../glib/object.h"

using namespace Inti;

/*  Gtl::Editable
 */

Gtk::CellEditable::~CellEditable()
{
}
	
GtkCellEditableIface*
Gtk::CellEditable::gtk_cell_editable_iface() const
{ 
	return peek<GtkCellEditableIface>(GTK_TYPE_CELL_EDITABLE); 
}
	
Gtk::CellEditable::operator GtkCellEditable* () const 
{ 
	return this ? gtk_cell_editable() : 0;
}

void 
Gtk::CellEditable::start_editing(const Gdk::Event *event)
{
	gtk_cell_editable_start_editing(gtk_cell_editable(), *event);
}

void
Gtk::CellEditable::editing_done()
{
	gtk_cell_editable_editing_done(gtk_cell_editable());
}

void 
Gtk::CellEditable::remove_widget()
{
	gtk_cell_editable_remove_widget(gtk_cell_editable());
}

/*  Gtk::CellEditableIface
 */

void
Gtk::CellEditableIface::init(GtkCellEditableIface *g_iface)
{
	g_iface->start_editing = &start_editing_proxy;
	g_iface->editing_done = &editing_done_proxy;
	g_iface->remove_widget = &remove_widget_proxy;
}

void
Gtk::CellEditableIface::start_editing_proxy(GtkCellEditable *cell_editable, GdkEvent *event)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(cell_editable));
	Gtk::CellEditable *tmp_cell_editable = dynamic_cast<Gtk::CellEditable*>(object);
	if (tmp_cell_editable)
		tmp_cell_editable->do_start_editing(event);
	else
	{
		GtkCellEditableIface *tmp_iface = GTK_CELL_EDITABLE_GET_IFACE(cell_editable);
		GtkCellEditableIface *g_iface = static_cast<GtkCellEditableIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->start_editing)
			g_iface->start_editing(cell_editable, event);
	}
}

void
Gtk::CellEditableIface::editing_done_proxy(GtkCellEditable *cell_editable)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(cell_editable));
	Gtk::CellEditable *tmp_cell_editable = dynamic_cast<Gtk::CellEditable*>(object);
	if (tmp_cell_editable)
		tmp_cell_editable->on_editing_done();
	else
	{
		GtkCellEditableIface *tmp_iface = GTK_CELL_EDITABLE_GET_IFACE(cell_editable);
		GtkCellEditableIface *g_iface = static_cast<GtkCellEditableIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->editing_done)
			g_iface->editing_done(cell_editable);
	}
}

void
Gtk::CellEditableIface::remove_widget_proxy(GtkCellEditable *cell_editable)
{
	G::Object *object = G::Object::pointer<G::Object>(G_OBJECT(cell_editable));
	Gtk::CellEditable *tmp_cell_editable = dynamic_cast<Gtk::CellEditable*>(object);
	if (tmp_cell_editable)
		tmp_cell_editable->on_remove_widget();
	else
	{
		GtkCellEditableIface *tmp_iface = GTK_CELL_EDITABLE_GET_IFACE(cell_editable);
		GtkCellEditableIface *g_iface = static_cast<GtkCellEditableIface*>(g_type_interface_peek_parent(tmp_iface));
		if (g_iface->remove_widget)
			g_iface->remove_widget(cell_editable);
	}
}


/*  Overridable GtkCellEditable methods
 */

void
Gtk::CellEditable::do_start_editing(GdkEvent *event)
{
	GtkCellEditableIface *g_iface = peek_parent<GtkCellEditableIface>(gtk_cell_editable_iface());
	if (g_iface->start_editing)
		g_iface->start_editing(gtk_cell_editable(), event);
}

/*  Signal handlers
 */

void
Gtk::CellEditable::on_editing_done()
{
	GtkCellEditableIface *g_iface = peek_parent<GtkCellEditableIface>(gtk_cell_editable_iface());
	if (g_iface->editing_done)
		g_iface->editing_done(gtk_cell_editable());
}

void
Gtk::CellEditable::on_remove_widget()
{
	GtkCellEditableIface *g_iface = peek_parent<GtkCellEditableIface>(gtk_cell_editable_iface());
	if (g_iface->remove_widget)
		g_iface->remove_widget(gtk_cell_editable());
}

/*  Signals
 */

const Gtk::CellEditable::EditingDoneSignalType Gtk::CellEditable::editing_done_signal("editing_done");

const Gtk::CellEditable::RemoveWidgetSignalType Gtk::CellEditable::remove_widget_signal("remove_widget");

