/*
 *  SQLGetInstalledDrivers.c
 *
 *  $Id: SQLGetInstalledDrivers.c,v 1.1 2001/06/07 00:48:50 source Exp $
 *
 *  Get a list of installed drivers
 *
 *  The iODBC driver manager.
 *
 *  Copyright (C) 2001 by OpenLink Software <iodbc@openlinksw.com>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <iodbc.h>
#include <iodbcinst.h>

#include "misc.h"
#include "iodbc_error.h"

extern BOOL GetAvailableDrivers ( LPCSTR lpszInfFile, LPSTR lpszBuf,
    WORD cbBufMax,WORD FAR *pcbBufOut,BOOL infFile);

BOOL INSTAPI
SQLGetInstalledDrivers (LPSTR lpszBuf, WORD cbBufMax, WORD FAR *pcbBufOut)
{
  char path[1024] = { 0 };

  return SQLGetAvailableDrivers (_iodbcadm_getinifile (path, sizeof (path),
	  TRUE, FALSE), lpszBuf, cbBufMax, pcbBufOut);
}
