# Perl5 script to make a mapping table between Unicode and Non-Unicode character sets.
# Invoke as:
#   perl ucs-to-iso.pl /path/to/text-mapping-datas/*.TXT

require 5;

$pool_h = 'ucs-to-iso-pool.h' if (!defined($pool_h));
$u2i_h = 'ucs-to-iso.h' if (!defined($u2i_h));
$i2u_h = 'iso-to-ucs.h' if (!defined($i2u_h));

require 'ucs-to-iso-lib.pl';
require 'mbbtri.pl';

my ($map) = &make_map;

my $mb_u2i_last_mask = 1 << 31;

local (*P);

open(P, ">$pool_h") || die "open(P, \">$pool_h\"): $!";

my $u2i = &bt_new;
my $i2u = &bt_new;
my ($ucs, $pool, @def, $i);

for ($ucs = 0xA0, $pool= 0 ; $ucs < @$map ; ++$ucs) {
  if (ref($map->[$ucs]) eq 'HASH') {
    my $iso;

    &bt_add($u2i, $ucs, $pool);
    @def = sort {$a->[0] <=> $b->[0]} values %{$map->[$ucs]};

    for ($i = 0 ; $i < $#def ; ++$i) {
      $iso = &mb_word_enc(@{$def[$i]}[1, 0]);
      &bt_add($i2u, $iso, $ucs);
      printf P "0x%X,\n", $iso;
      ++$pool;
    }

    $iso = &mb_word_enc(@{$def[$i]}[1, 0]);
    &bt_add($i2u, $iso, $ucs);
    printf P "0x%X,\n", $iso | $mb_u2i_last_mask;
    ++$pool;
  }
}

close(P);

&bt_optimize($u2i);
&bt_make_c_header($u2i, $u2i_h);
&bt_optimize($i2u);
&bt_make_c_header($i2u, $i2u_h);

exit;
