/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.managed.api.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.jboss.managed.api.ManagedDeployment.DeploymentPhase;

/**
 * An annotation identifying a managed deployment
 * 
 * @author Scott.Stark@jboss.org
 * @version $Revision: 73460 $
 */
@Inherited
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
public @interface ManagementDeployment
{
   /**
    * Get the simple name (x.ear) for the deployment. Generally
    * this is taken from the DeploymentUnit.simpleName.
    * @return simple name of the deployment
    */
   String simpleName() default ManagementConstants.GENERATED;

   /**
    * A description of the managed deployment
    * @return description of the managed deployment
    */
   String description() default ManagementConstants.GENERATED;

   /**
    * The phase the deployment belongs to
    * @return the phase of the deployment
    */
   DeploymentPhase phase() default DeploymentPhase.APPLICATION;

   /**
    * Get the deployment/module types.
    * @return deployment types
    */
   String[] types() default {};

}
