/*
 * Farsight Voice+Video library
 *  Copyright 2006 Collabora Ltd, 
 *  Copyright 2006 Nokia Corporation
 *   @author: Philippe Khalaf <philippe.khalaf@collabora.co.uk>.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <talk/base/thread.h>
#include <talk/base/physicalsocketserver.h>
#include <talk/base/network.h>
#include <talk/base/socketaddress.h>
#include <talk/p2p/base/socketmanager.h>
#include <talk/p2p/base/helpers.h>
#include <talk/p2p/client/basicportallocator.h>

#include <iostream>

#include "socketclient.h"

SocketClient::SocketClient(SocketAddress *stun_addr,
        SocketAddress *turn_addr)
{
    Thread *worker_thread;
    NetworkManager *network_manager;
    BasicPortAllocator *port_allocator;

    socket = NULL;
    sigl1 = NULL;
    sigl2 = NULL;

    cricket::InitRandom("boo", 3);

    worker_thread = new cricket::Thread();

    network_manager = new cricket::NetworkManager();

    port_allocator =
        new cricket::BasicPortAllocator(network_manager, stun_addr, turn_addr);

    socket_manager = new cricket::SocketManager(
            port_allocator, worker_thread);
    //socket_manager = new cricket::SocketManager(
    //        port_allocator, NULL);
    //

    socket_manager->SignalRequestSignaling.connect(this,
            &SocketClient::OnRequestSignaling);

    worker_thread->Start();

    //socket_manager->SignalState.connect(this, &SocketClient::OnSocketState);
}

SocketClient::~SocketClient()
{
    delete socket_manager;
}

void SocketClient::OnSocketRead(P2PSocket *socket, const char *data, size_t len)
{
    //std::cout << "Got packet!!!" << socket << std::endl;
}

void SocketClient::CreateSocket(const std::string &name)
{
    /* TODO attach a SocketMonitor to this socket */
    socket = socket_manager->CreateSocket(name);

    socket->SignalReadPacket.connect(this, &SocketClient::OnSocketRead);
    socket_manager->OnSignalingReady();
}

void SocketClient::OnRequestSignaling() {
    std::cout << "OnRequestsignaling called, sending SignalingReady" << std::endl;
    socket_manager->OnSignalingReady();
}
