/*
 * Decompiled with CFR 0.152.
 */
package gnu.jpdf;

import gnu.jpdf.PDFBorder;
import gnu.jpdf.PDFObject;
import gnu.jpdf.PDFStringHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class PDFAnnot
extends PDFObject
implements Serializable {
    public static final short SOLID = 0;
    public static final short DASHED = 1;
    public static final short BEVELED = 2;
    public static final short INSET = 3;
    public static final short UNDERLINED = 4;
    private final String subtype;
    private final int l;
    private final int b;
    private final int r;
    private final int t;
    private String s;
    private static final int FULL_PAGE = -9999;
    private PDFObject dest;
    private int fl;
    private int fb;
    private int fr;
    private int ft;
    private PDFBorder border;

    protected PDFAnnot(String string, int n, int n2, int n3, int n4) {
        super("/Annot");
        this.subtype = string;
        this.l = n;
        this.b = n2;
        this.r = n3;
        this.t = n4;
    }

    public PDFAnnot(int n, int n2, int n3, int n4, String string) {
        this("/Text", n, n2, n3, n4);
        this.s = string;
    }

    public PDFAnnot(int n, int n2, int n3, int n4, PDFObject pDFObject) {
        this("/Link", n, n2, n3, n4);
        this.dest = pDFObject;
        this.fl = -9999;
    }

    public PDFAnnot(int n, int n2, int n3, int n4, PDFObject pDFObject, int n5, int n6, int n7, int n8) {
        this("/Link", n, n2, n3, n4);
        this.dest = pDFObject;
        this.fl = n5;
        this.fb = n6;
        this.fr = n7;
        this.ft = n8;
    }

    public void setBorder(short s, double d) {
        this.border = new PDFBorder(s, d);
        this.pdfDocument.add(this.border);
    }

    public void setBorder(double d, double[] dArray) {
        this.border = new PDFBorder(d, dArray);
        this.pdfDocument.add(this.border);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.writeStart(outputStream);
        outputStream.write("/Subtype ".getBytes());
        outputStream.write(this.subtype.getBytes());
        outputStream.write("\n/Rect [".getBytes());
        outputStream.write(Integer.toString(this.l).getBytes());
        outputStream.write(" ".getBytes());
        outputStream.write(Integer.toString(this.b).getBytes());
        outputStream.write(" ".getBytes());
        outputStream.write(Integer.toString(this.r).getBytes());
        outputStream.write(" ".getBytes());
        outputStream.write(Integer.toString(this.t).getBytes());
        outputStream.write("]\n".getBytes());
        if (this.border == null) {
            outputStream.write("/Border [0 0 0]\n".getBytes());
        } else {
            outputStream.write("/BS ".getBytes());
            outputStream.write(this.border.toString().getBytes());
            outputStream.write("\n".getBytes());
        }
        if (this.subtype.equals("/Text")) {
            outputStream.write("/Contents ".getBytes());
            outputStream.write(PDFStringHelper.makePDFString(this.s).getBytes());
            outputStream.write("\n".getBytes());
        } else if (this.subtype.equals("/Link")) {
            outputStream.write("/Dest [".getBytes());
            outputStream.write(this.dest.toString().getBytes());
            if (this.fl == -9999) {
                outputStream.write(" /Fit]".getBytes());
            } else {
                outputStream.write(" /FitR ".getBytes());
                outputStream.write(Integer.toString(this.fl).getBytes());
                outputStream.write(" ".getBytes());
                outputStream.write(Integer.toString(this.fb).getBytes());
                outputStream.write(" ".getBytes());
                outputStream.write(Integer.toString(this.fr).getBytes());
                outputStream.write(" ".getBytes());
                outputStream.write(Integer.toString(this.ft).getBytes());
                outputStream.write("]".getBytes());
            }
            outputStream.write("\n".getBytes());
        }
        this.writeEnd(outputStream);
    }
}

