/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.misc.CVM;

public class ThreadRegistry {
    private static Object staticLock = new Object();
    private static boolean allExitRequestedFlag = false;
    private static Vector threadList = new Vector();
    private static Vector debugBuffer;
    private static boolean threadCreationDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(Thread thread) {
        Object object = staticLock;
        synchronized (object) {
            threadList.addElement(thread);
            ThreadRegistry.dprintln("New thread " + thread.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Thread thread) {
        Object object = staticLock;
        synchronized (object) {
            threadList.removeElement(thread);
            try {
                ThreadRegistry.dprintln("Thread " + thread.getName() + " removed");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean threadCreationAllowed() {
        return !threadCreationDisabled;
    }

    public static void waitAllUserThreadsExit() {
        ThreadRegistry.dprintln("Waiting for all user threads to exit");
        ThreadRegistry.waitThreadsExit(false);
    }

    public static void waitAllSystemThreadsExit() {
        ThreadRegistry.dprintln("Asking all SystemThreads to exit");
        allExitRequestedFlag = true;
        ThreadRegistry.waitThreadsExit(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitThreadsExit(boolean bl) {
        boolean bl2;
        Thread thread = Thread.currentThread();
        do {
            Thread thread2;
            int n;
            Vector vector;
            bl2 = false;
            Object object = staticLock;
            synchronized (object) {
                vector = (Vector)threadList.clone();
            }
            int n2 = vector.size();
            if (bl) {
                for (n = 0; n < n2; ++n) {
                    thread2 = (Thread)vector.elementAt(n);
                    if (thread2 == thread) continue;
                    ThreadRegistry.dprintln("Asking " + (thread2.isDaemon() ? "system" : "user") + " thread " + thread2.getName() + " to exit");
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            thread2.interrupt();
                            return null;
                        }
                    });
                }
            }
            block7: for (n = 0; n < n2; ++n) {
                thread2 = (Thread)vector.elementAt(n);
                if (thread2 == thread || !bl && thread2.isDaemon()) continue;
                ThreadRegistry.dprintln("Waiting for " + (thread2.isDaemon() ? "system" : "user") + " thread " + thread2.getName() + " to exit");
                bl2 = true;
                while (thread2.isAlive()) {
                    try {
                        thread2.join();
                        continue block7;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        } while (bl2);
    }

    public static boolean exitRequested() {
        if (allExitRequestedFlag) {
            ThreadRegistry.dprintln("System thread " + Thread.currentThread().getName() + " has recognized the request to exit");
        }
        return allExitRequestedFlag;
    }

    public static void resetExitRequest() {
        allExitRequestedFlag = false;
    }

    private static synchronized void dprintln(String string) {
        if (CVM.checkDebugFlags(32768) != 0) {
            if (System.err != null) {
                if (debugBuffer != null) {
                    int n = debugBuffer.size();
                    for (int i = 0; i < n; ++i) {
                        String string2 = (String)debugBuffer.elementAt(i);
                        System.err.println(string2);
                    }
                }
                debugBuffer = null;
                System.err.println(string);
            } else {
                if (debugBuffer == null) {
                    debugBuffer = new Vector();
                }
                debugBuffer.addElement(string);
            }
        }
    }

    static {
        threadCreationDisabled = false;
        if (!CVM.objectInflatePermanently(staticLock)) {
            throw new OutOfMemoryError();
        }
        if (!CVM.objectInflatePermanently(threadList)) {
            throw new OutOfMemoryError();
        }
    }
}

