/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.testng.IMethodSelector;
import org.testng.IMethodSelectorContext;
import org.testng.ITestNGMethod;
import org.testng.TestNGException;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Bsh;
import org.testng.internal.BshMock;
import org.testng.internal.Dynamic;
import org.testng.internal.IBsh;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlInclude;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlMethodSelector
implements IMethodSelector {
    private static final long serialVersionUID = -9030548178025605629L;
    private Map<String, String> m_includedGroups = Maps.newHashMap();
    private Map<String, String> m_excludedGroups = Maps.newHashMap();
    private List<XmlClass> m_classes = null;
    private String m_expression = null;
    private ListMultiMap<String, XmlInclude> m_includedMethods = Maps.newListMultiMap();
    private IBsh m_bsh = Dynamic.hasBsh() ? new Bsh() : new BshMock();
    private Map<String, String> m_logged = Maps.newHashMap();
    private boolean m_isInitialized = false;
    private List<ITestNGMethod> m_testMethods = null;

    @Override
    public boolean includeMethod(IMethodSelectorContext context, ITestNGMethod tm, boolean isTestMethod) {
        if (!this.m_isInitialized) {
            this.m_isInitialized = true;
            this.init(context);
        }
        boolean result = false;
        if (null != this.m_expression) {
            return this.m_bsh.includeMethodFromExpression(this.m_expression, tm);
        }
        result = this.includeMethodFromIncludeExclude(tm, isTestMethod);
        return result;
    }

    private boolean includeMethodFromIncludeExclude(ITestNGMethod tm, boolean isTestMethod) {
        boolean result = false;
        Method m = tm.getMethod();
        String[] groups = tm.getGroups();
        Map<String, String> includedGroups = this.m_includedGroups;
        Map<String, String> excludedGroups = this.m_excludedGroups;
        List<XmlInclude> includeList = this.m_includedMethods.get(MethodHelper.calculateMethodCanonicalName(tm));
        if (includedGroups.size() == 0 && excludedGroups.size() == 0 && !this.hasIncludedMethods() && !this.hasExcludedMethods()) {
            result = true;
        } else if (includedGroups.size() == 0 && excludedGroups.size() == 0 && !isTestMethod) {
            result = true;
        } else if (includeList != null) {
            result = true;
        } else {
            boolean isIncludedInGroups = XmlMethodSelector.isIncluded(groups, this.m_includedGroups.values());
            boolean isExcludedInGroups = XmlMethodSelector.isExcluded(groups, this.m_excludedGroups.values());
            if (isIncludedInGroups && !isExcludedInGroups) {
                result = true;
            } else if (isExcludedInGroups) {
                result = false;
            }
            if (isTestMethod) {
                Method method = tm.getMethod();
                Class<?> methodClass = method.getDeclaringClass();
                String fullMethodName = methodClass.getName() + "." + method.getName();
                String[] fullyQualifiedMethodName = new String[]{fullMethodName};
                for (XmlClass xmlClass : this.m_classes) {
                    Class cls = xmlClass.getSupportClass();
                    if (!this.assignable(methodClass, cls)) continue;
                    List<String> includedMethods = this.createQualifiedMethodNames(xmlClass, this.toStringList(xmlClass.getIncludedMethods()));
                    boolean isIncludedInMethods = XmlMethodSelector.isIncluded(fullyQualifiedMethodName, includedMethods);
                    List<String> excludedMethods = this.createQualifiedMethodNames(xmlClass, xmlClass.getExcludedMethods());
                    boolean isExcludedInMethods = XmlMethodSelector.isExcluded(fullyQualifiedMethodName, excludedMethods);
                    if (!result) continue;
                    result = isIncludedInMethods && !isExcludedInMethods;
                }
            }
        }
        Package pkg = m.getDeclaringClass().getPackage();
        String methodName = pkg != null ? pkg.getName() + "." + m.getName() : m.getName();
        this.logInclusion(result ? "Including" : "Excluding", "method", methodName + "()");
        return result;
    }

    private boolean assignable(Class sourceClass, Class targetClass) {
        return sourceClass.isAssignableFrom(targetClass) || targetClass.isAssignableFrom(sourceClass);
    }

    private void logInclusion(String including, String type, String name) {
        if (!this.m_logged.containsKey(name)) {
            XmlMethodSelector.log(4, including + " " + type + " " + name);
            this.m_logged.put(name, name);
        }
    }

    private boolean hasIncludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getIncludedMethods().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasExcludedMethods() {
        for (XmlClass xmlClass : this.m_classes) {
            if (xmlClass.getExcludedMethods().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private List<String> toStringList(List<XmlInclude> methods) {
        List<String> result = Lists.newArrayList();
        for (XmlInclude m : methods) {
            result.add(m.getName());
        }
        return result;
    }

    private List<String> createQualifiedMethodNames(XmlClass xmlClass, List<String> methods) {
        List<String> vResult = Lists.newArrayList();
        for (Class cls = xmlClass.getSupportClass(); null != cls; cls = cls.getSuperclass()) {
            Iterator<String> i$ = methods.iterator();
            while (i$.hasNext()) {
                String im;
                String methodName = im = i$.next();
                Method[] allMethods = cls.getDeclaredMethods();
                Pattern pattern = Pattern.compile(methodName);
                for (Method m : allMethods) {
                    if (!pattern.matcher(m.getName()).matches()) continue;
                    vResult.add(this.makeMethodName(cls.getName(), m.getName()));
                }
            }
        }
        return vResult;
    }

    private String makeMethodName(String className, String methodName) {
        return className + "." + methodName;
    }

    private void checkMethod(String className, String methodName) {
        Pattern p = Pattern.compile(methodName);
        try {
            Class<?> c = Class.forName(className);
            for (Method m : c.getMethods()) {
                if (!p.matcher(m.getName()).matches()) continue;
                return;
            }
        }
        catch (ClassNotFoundException e) {
            throw new TestNGException(e);
        }
        Utils.log("Warning", 2, "The regular exception \"" + methodName + "\" didn't match any" + " method in class " + className);
    }

    public void setXmlClasses(List<XmlClass> classes) {
        this.m_classes = classes;
        for (XmlClass c : classes) {
            for (XmlInclude m : c.getIncludedMethods()) {
                this.checkMethod(c.getName(), m.getName());
                String methodName = this.makeMethodName(c.getName(), m.getName());
                this.m_includedMethods.put(methodName, m);
            }
        }
    }

    public Map<String, String> getExcludedGroups() {
        return this.m_excludedGroups;
    }

    public Map<String, String> getIncludedGroups() {
        return this.m_includedGroups;
    }

    public void setExcludedGroups(Map<String, String> excludedGroups) {
        this.m_excludedGroups = excludedGroups;
    }

    public void setIncludedGroups(Map<String, String> includedGroups) {
        this.m_includedGroups = includedGroups;
    }

    private static boolean isIncluded(String[] groups, Collection<String> includedGroups) {
        if (includedGroups.size() == 0) {
            return true;
        }
        return XmlMethodSelector.isMemberOf(groups, includedGroups);
    }

    private static boolean isExcluded(String[] groups, Collection<String> excludedGroups) {
        return XmlMethodSelector.isMemberOf(groups, excludedGroups);
    }

    private static boolean isMemberOf(String[] groups, Collection<String> list) {
        for (String group : groups) {
            for (String o : list) {
                String regexpStr = o.toString();
                boolean match = Pattern.matches(regexpStr, group);
                if (!match) continue;
                return true;
            }
        }
        return false;
    }

    private static void log(int level, String s) {
        Utils.log("XmlMethodSelector", level, s);
    }

    private static void ppp(String s) {
        System.out.println("[XmlMethodSelector] " + s);
    }

    public void setExpression(String expression) {
        this.m_expression = expression;
    }

    @Override
    public void setTestMethods(List<ITestNGMethod> testMethods) {
        this.m_testMethods = testMethods;
    }

    private void init(IMethodSelectorContext context) {
        String[] groups = this.m_includedGroups.keySet().toArray(new String[this.m_includedGroups.size()]);
        HashSet<String> groupClosure = new HashSet<String>();
        HashSet<ITestNGMethod> methodClosure = new HashSet<ITestNGMethod>();
        List<ITestNGMethod> includedMethods = Lists.newArrayList();
        for (ITestNGMethod m : this.m_testMethods) {
            if (!this.includeMethod(context, m, true)) continue;
            includedMethods.add(m);
        }
        MethodGroupsHelper.findGroupTransitiveClosure(this, includedMethods, this.m_testMethods, groups, groupClosure, methodClosure);
        if (this.m_includedGroups.size() > 0) {
            for (String g : groupClosure) {
                XmlMethodSelector.log(4, "Including group " + (this.m_includedGroups.containsKey(g) ? ": " : "(implicitly): ") + g);
                this.m_includedGroups.put(g, g);
            }
            for (ITestNGMethod m : methodClosure) {
                String methodName = m.getMethod().getDeclaringClass().getName() + "." + m.getMethodName();
                List<XmlInclude> includeList = this.m_includedMethods.get(methodName);
                XmlInclude xi = new XmlInclude(methodName);
                this.m_includedMethods.put(methodName, xi);
                this.logInclusion("Including", "method ", methodName);
            }
        }
    }
}

