/*
 * Decompiled with CFR 0.152.
 */
package org.testng.xml;

import com.google.inject.internal.Maps;
import java.util.Map;
import org.testng.collections.CollectionUtils;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.dom.OnElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlDependencies {
    private Map<String, String> m_xmlDependencyGroups = Maps.newHashMap();

    @OnElement(tag="group", attributes={"name", "depends-on"})
    public void onGroup(String name, String dependsOn) {
        this.m_xmlDependencyGroups.put(name, dependsOn);
    }

    public Map<String, String> getDependencies() {
        return this.m_xmlDependencyGroups;
    }

    public String toXml(String indent) {
        XMLStringBuffer xsb = new XMLStringBuffer(indent);
        boolean hasElements = CollectionUtils.hasElements(this.m_xmlDependencyGroups);
        if (hasElements) {
            xsb.push("dependencies");
        }
        for (Map.Entry<String, String> entry : this.m_xmlDependencyGroups.entrySet()) {
            xsb.addEmptyElement("include", "name", entry.getKey(), "depends-on", entry.getValue());
        }
        if (hasElements) {
            xsb.pop("dependencies");
        }
        return xsb.toXML();
    }
}

