// $Id: analytic_function.C,v 1.7 2007-10-21 20:48:51 benkirk Exp $

// The libMesh Finite Element Library.
// Copyright (C) 2002-2007  Benjamin S. Kirk, John W. Peterson
  
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
  
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
  
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA



// C++ includes


// Local Includes
#include "analytic_function.h"



//------------------------------------------------------------------
// AnalyticFunction methods
AnalyticFunction::AnalyticFunction (Number fptr(const Point& p,
						const Real time)) :
  FunctionBase (),
  _number_fptr (fptr)
{
  assert (fptr != NULL);
  this->_initialized = true;
}




AnalyticFunction::AnalyticFunction (void fptr(DenseVector<Number>& output,
					      const Point& p,
					      const Real time)) :
  FunctionBase (),
  _vector_fptr (fptr)
{
  assert (fptr != NULL);
  this->_initialized = true;
}




AnalyticFunction::~AnalyticFunction ()
{
}





void AnalyticFunction::init ()
{
  // dumb double-test
  assert ((_number_fptr != NULL) || (_vector_fptr != NULL));

  // definitely ready
  this->_initialized = true;
}
