# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl test.pl'

######################### We start with some black magic to print on failure.

# Change 1..1 below to 1..last_test_to_print .
# (It may become useful if the test is moved to ./t subdirectory.)

BEGIN { $| = 1; print "1..17\n"; }
END {print "not ok 1\n" unless $loaded;}
use Net::IPNetMember;
$loaded = 1;
print "ok 1\n";

######################### End of black magic.

# Insert your test code below (better if it prints "ok 13"
# (correspondingly "not ok 13") depending on the success of chunk 13
# of the test code):

$ntest = 1;

my $test = new Net::IPNetMember();
$ntest++;
if ( $test->add("GROUP-1", "200.200.200.0", "255.255.255.0") )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( $test->add("GROUP-1", "200.200.208.128", "255.255.255.128") )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( $test->add("GROUP-2", "200.200.204.0", "255.255.254.0") )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( $test->add("GROUP-3", "200.200.204.128/26" ) )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

print();

$ntest++;
if ( ($grp = $test->find("200.200.200.3")) eq 'GROUP-1' )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( ($grp = $test->find("200.200.204.124")) eq 'GROUP-2' )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( ($grp = $test->find("200.200.204.136")) eq 'GROUP-3' )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
my $t1 = new Net::IPNetMember;
if ( $t1->add("site local", "10.0.0.0/8") )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( $t1->add("site local", "172.16.0.0/12") )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( $t1->add("site local", "192.168.0.0/16") )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( $t1->add("link local", "169.254.0.0/16") )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( defined ($grp = $t1->find("11.200.204.136")) )
   { print "not ok $ntest\n"; }
  else
   { print "ok $ntest\n"; }

$ntest++;
if ( ($grp = $t1->find("192.168.215.31")) eq 'site local' )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( ($grp = $t1->find("172.17.10.56")) eq 'site local' )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( ($grp = $t1->find("10.134.87.30")) eq 'site local' )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }

$ntest++;
if ( ($grp = $t1->find("169.254.231.42")) eq 'link local' )
   { print "ok $ntest\n"; }
  else
   { print "not ok $ntest\n"; }


 
exit;

 
