/* acclist.c
*/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/



#include "acclist.h"
#include <stdio.h>
#include <stdlib.h>
#include <openhbci/outboxjobs.h>
#include <openhbci/bank.h>


HBCI_Error *acclist(HBCI_API *hbciif,
		   HBCI_CmdLineOptions* opt)
{
    HBCI_OutboxJobGetAccounts* job; 
    int country;
    const char* bankCode;
    const char* accnr;
    const char* user_id, *cust_id;
    const HBCI_Customer* cust;
    const HBCI_User* user;
    HBCI_Bank *bank;
    HBCI_Error* err = 0;
    /*const char* accountNumber;*/
    /*const char* accountName;*/
    const HBCI_Account* acc;
    const list_HBCI_Account *acclist;
    list_HBCI_Account_iter *acciter, *accl_end;
    /*int i;*/
    
    accnr = HBCI_CmdLineOptions_getStringVariable(opt, "accnr", "*");
    bankCode = HBCI_CmdLineOptions_getStringVariable(opt, "instid", "*");
    country = HBCI_CmdLineOptions_getIntVariable(opt, "country", 280);
    user_id = HBCI_CmdLineOptions_getStringVariable(opt, "user", "*");
    cust_id = HBCI_CmdLineOptions_getStringVariable(opt, "customer", "*");

    /* check if the bank exists */
    bank = HBCI_API_findBank(hbciif, country, bankCode);
    if (!bank) 
	return HBCI_Error_new("acclist()",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "bank not found", "");
    printf("Now having bank with BLZ %s.\n", HBCI_Bank_bankCode(bank));
    acclist = HBCI_Bank_accounts(bank);
    printf("So far accounts found: %d stueck.\n", 
	   list_HBCI_Account_size(acclist));
    
    acciter = list_HBCI_Account_begin(acclist);
    accl_end = list_HBCI_Account_end(acclist);
    for ( ; 
	  !list_HBCI_Account_iter_equal(acciter, accl_end) ; 
	  list_HBCI_Account_iter_next(acciter) ) 
	{
	    acc = list_HBCI_Account_iter_get(acciter);
	    if (acc)
		printf("Account no. %s found.\n", 
		       HBCI_Account_accountId(acc));
	    
	}
    list_HBCI_Account_iter_delete(acciter);
    list_HBCI_Account_iter_delete(accl_end);

    user = HBCI_Bank_findUser(bank, user_id);
    if (!user)
	return HBCI_Error_new("acclist()",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "user not found", "");
    printf("Now having user with userid %s.\n", HBCI_User_userId(user));
    
    cust= HBCI_User_findCustomer(user,
				cust_id);
    if (!cust)
	return HBCI_Error_new("acclist()",
			     ERROR_LEVEL_NORMAL,
			     0,
			     ERROR_ADVISE_DONTKNOW,
			     "customer(s) not found", "");
    /* this const-warning is okay and can be ignored. */
    job = HBCI_OutboxJobGetAccounts_new((HBCI_Customer *)cust); 
    HBCI_API_addJob(hbciif, HBCI_OutboxJobGetAccounts_OutboxJob(job));
    
    /* execute queue */
    err = HBCI_API_executeQueue(hbciif, 1);

    /* get the resulted account list */
    acclist = HBCI_Bank_accounts(bank);
    printf("Accounts found: %d stueck.\n", list_HBCI_Account_size(acclist));
    
    acciter = list_HBCI_Account_begin(acclist);
    accl_end = list_HBCI_Account_end(acclist);
    for ( ; 
	  !list_HBCI_Account_iter_equal(acciter, accl_end) ; 
	  list_HBCI_Account_iter_next(acciter) ) 
	{
	    acc = list_HBCI_Account_iter_get(acciter);
	    if (acc)
		printf("Account no. %s found.\n", 
		       HBCI_Account_accountId(acc));
	    
	}
    
    return err;
}
