/* main.c
   Copyright 2002 by Christian Stimming <stimming@tuhh.de> */

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <openhbci/error.h>
#include <openhbci/cmdlineoptions.h>
#include <openhbci/account.h>
#include <openhbci/customer.h>
#include <openhbci/api.h>

// to test headers for C standard compliance:
#include <openhbci/mediumpluginlist.h>

#include "interactor.h"
#include "getbalance.h"
#include "createuser.h"
#include "acclist.h"
#include "turnover.h"

/* Most of this is heavily copied from src/aqmoney/main.cpp by Martin
   Preu. */
s_CmdLineOptionDescr options[]={
    {
        "user",                                    /* config item name */
        CLO_FLAGS_HAS_ARGUMENT,                  /* flags */
        "user",                                    /* long option name */
        "u",                                       /* short option name */
        "userid assigned to you by your institute" /* description */
    },
    {
        "customer",                                
        CLO_FLAGS_HAS_ARGUMENT,                    
        "customer",                                
        "",                                        
        "customerid assigned to you by your institute"
    },
    {
        "custName",
        CLO_FLAGS_HAS_ARGUMENT,
        "custName",
        "",
        "name of the customer (e.g. \"private\")"
    },
    {
        "instid",
        CLO_FLAGS_HAS_ARGUMENT,
        "institute",
        "i",
        "code of your credit institute (\"Bankleitzahl\")"
    },
    {
        "country",
        CLO_FLAGS_HAS_ARGUMENT,
        "country",
        "c",
        "country code (\"280\" for Germany)"
    },
    {
        "context",
        CLO_FLAGS_HAS_ARGUMENT,
        "context",
        "",
        "context on a medium"
    },
    {
        "medium",
        CLO_FLAGS_HAS_ARGUMENT,
        "medium",
        "",
        "DDV: cardnumber, RDH: path to the file to create"
    },
    {
        "secmode",
        CLO_FLAGS_HAS_ARGUMENT,
        "security",
        "",
        "security mode (DDV or RDH)"
    },
    {
        "server",
        CLO_FLAGS_HAS_ARGUMENT,
        "server",
        "",
        "ip address of the institutes server"
    },
    {
        "key",
        CLO_FLAGS_HAS_ARGUMENT,
        "key",
        "",
        "key to select (user OR institute)"
    },
    {
        "output",
        CLO_FLAGS_HAS_ARGUMENT,
        "output",
        "o",
        "what to output (txt OR html)"
    },
    {
        "accnr",
        CLO_FLAGS_HAS_ARGUMENT,
        "account",
        "a",
        "account number"
    },
    {
        "cmd",
        CLO_FLAGS_HAS_ARGUMENT,
        "command",
        "d",
        "the command to execute (see man)"
    },
    {
        "ro",
        0,
        "readonly",
        "r",
        "does not allow alteration of your account's balance at the bank"
    },
    {
        "retrievalo",
        0,
        "retonly",
        "rt",
        "does only save essential HBCI data, no balance/transactions"
    },
    {
        "lang",
        CLO_FLAGS_HAS_ARGUMENT,
        "language",
        "l",
        "select language"
    },
    {
        "cfgfile",
        CLO_FLAGS_HAS_ARGUMENT,
        "configfile",
        "C",
        "use this config file"
    },
    {
        "fromdate",
        CLO_FLAGS_HAS_ARGUMENT,
        "fromdate",
        "",
        "first date (YYYYMMDD)"
    },
    {
        "todate",
        CLO_FLAGS_HAS_ARGUMENT,
        "todate",
        "",
        "last date (YYYYMMDD)"
    },
    {
        "tfile",
        CLO_FLAGS_HAS_ARGUMENT,
        "tfile",
        "",
        "name of file containing transfers to be done"
    },
    {
        "outfile",
        CLO_FLAGS_HAS_ARGUMENT,
        "outfile",
        "",
        "name of file to write to"
    },
    {
        "outformat",
        CLO_FLAGS_HAS_ARGUMENT,
        "outformat",
        "",
        "format of output file"
    },
    {
        "xactions",
        0,
        "transactions",
        "xa",
        "used with \"dump\" to show transactions"
    },
    {
        "balance",
        0,
        "balance",
        "",
        "used with \"dump\" to show balances"
    },
    {
        "sto",
        0,
        "sto",
        "",
        "used with \"dump\" to show standing orders"
    },
    {
        "msg",
        0,
        "msg",
        "",
        "used with \"dump\" to show institute messages"
    },
    {
        "syncmode",
        CLO_FLAGS_HAS_ARGUMENT,
        "syncmode",
        "",
        "select the sync mode (for command sync)"
    },
    {
        "help",
        CLO_FLAGS_LAST,
        "help",
        "h",
        "show this help screen"
    }
};



int main(int argc, char **argv) {
    HBCI_Error* err;
    HBCI_CmdLineOptions* opt;
    HBCI_API* hbciif;
    int ro;
    int append;
    const char* cmd;
    int rv;
    /*const char* accnr;*/
    /*const char* instid;*/
    /*int country;*/
    const char* homedir;
    char* cfgfile;
    const char* cfgfile_default;
    /*char* cfgdir;*/
    /*const char* cfgdir_default;*/

    homedir = getenv("HOME");

    opt = HBCI_CmdLineOptions_new();
    err = HBCI_CmdLineOptions_parseOptions(opt, argc, argv, options);
    if (!HBCI_Error_isOk(err)) {
        fprintf(stderr,"Encountered an error: %s\n",
                HBCI_Error_errorString(err));
        return 1;
    }
    HBCI_Error_delete(err);
    /* check if help requested */
    if (HBCI_CmdLineOptions_findVariableIsValid(opt, "help")) {
        fprintf(stdout, "Usage:\n");
        fprintf(stdout, " %s <OPTIONS>\n",argv[0]);
        fprintf(stdout, " where <OPTIONS> can be:\n");
        fprintf(stdout, "%s\n", 
		HBCI_CmdLineOptions_usage(opt, options));
        return 1;
    }

    /* get some variables */
    ro = HBCI_CmdLineOptions_findVariableIsValid(opt, "ro");
    append = HBCI_CmdLineOptions_findVariableIsValid(opt, "append");
    cmd = HBCI_CmdLineOptions_getStringVariable(opt, "cmd", "");
    if (strlen(cmd)==0) {
        fprintf(stderr,"ERROR: no command given.\n");
        return 1;
    }

    /* create hbci interface */
    hbciif = HBCI_API_new
        (ro,
         HBCI_CmdLineOptions_getIntVariable(opt,
                                       "retrievalo",
                                       0));
    /*hbciif.ref().systemName="AqMoney";
      hbciif.ref().systemVersion="0.1"; */

    /* Set interactor */
    HBCI_Hbci_setInteractor(HBCI_API_Hbci(hbciif), new_interactor(), 1);
    /* Set pmonitor */
    HBCI_API_setMonitor(hbciif, new_pmonitor(), 1);
        
    /* load environment */
    cfgfile_default = "/.aqmoney/aqmoney2.conf"; /* with leading slash */
    cfgfile = (char*)malloc(strlen(homedir)+strlen(cfgfile_default)+1);
    strcpy(cfgfile, homedir);
    strcat(cfgfile, cfgfile_default);

    err = HBCI_API_loadEnvironment
	(hbciif,
	 HBCI_CmdLineOptions_getStringVariable(opt,
					  "cfgfile",
					  cfgfile));
    if (!HBCI_Error_isOk(err)) {
	fprintf(stderr,"At HBCI_API_loadEnvironment: ERROR: %s\n",
		HBCI_Error_errorString(err));
	return 0x02;
    }
    HBCI_Error_delete(err);

    /* You can check some medium-plugin related functions here. */
    /*printf("mediumType: %d\n", HBCI_API_mediumType(hbciif, "DDVCard"));*/

    /* do some nasty things */
    rv=0x08;

    if (strcmp(cmd,"balance")==0) {
	err = getBalance(hbciif,opt);
    }
    else if (strcmp(cmd, "createuser")==0) {
        err = createUser(hbciif,opt);
    }
    else if (strcmp(cmd, "acclist")==0)  {
        err = acclist(hbciif,opt);
    }
    else if (strcmp(cmd, "turnover")==0) {
        err = turnover(hbciif,opt);
    }
#ifdef UNFINISHED_FROM_HERE
    else if (-1!=c_parser::cmpPattern(cmd,"getkeys",false)){
        err=getKeys(hbciif,opt);
    }
    else if (-1!=c_parser::cmpPattern(cmd,"sendkeys",false)) {
        err=sendKeys(hbciif,opt);
    }
    else if (-1!=c_parser::cmpPattern(cmd,"iniletter",false)) {
        err=iniletter(hbciif,opt);
    }
    else if (-1!=c_parser::cmpPattern(cmd,"accadd",false)) {
        err=accAdd(hbciif,opt);
    }
    else if (-1!=c_parser::cmpPattern(cmd,"dump",false)) {
        err=dump(hbciif,opt);
    }
    else if (-1!=c_parser::cmpPattern(cmd,"transfer",false)) {
        err=transfer(hbciif,opt);
    }
    else if (-1!=c_parser::cmpPattern(cmd,"debitnote",false)) {
        err=debitnote(hbciif,opt);
    }
    else if (-1!=c_parser::cmpPattern(cmd,"sync",false)) {
        err=synchronize(hbciif,opt);
    }
    else if (-1!=c_parser::cmpPattern(cmd,"texport",false)) {
        err=texport(hbciif,opt);
    }
#endif
    else {
        err = HBCI_Error_new("main()",
			   ERROR_LEVEL_NORMAL,
			   0,
			   ERROR_ADVISE_DONTKNOW,
			   "Unknown command",
			   cmd);
        rv=1;
    }
    if (err && !HBCI_Error_isOk(err)) {
        fprintf(stderr,"%s\n",
                HBCI_Error_errorString(err));
    }
    else
        rv=0;
    HBCI_Error_delete(err);

    /* save environment */
    err = HBCI_API_saveEnvironment(hbciif, 
				  HBCI_CmdLineOptions_getStringVariable(opt,
								   "cfgfile",
								   cfgfile));
    HBCI_API_delete(hbciif);
    
    if (!HBCI_Error_isOk(err)) {
        fprintf(stderr,"%s\n",
                HBCI_Error_errorString(err));
        rv|=0x04;
    }
    HBCI_Error_delete(err);

    return rv;
}
