/***************************************************************************
 $RCSfile: bankimpl.cpp,v $
 -------------------
 cvs         : $Id: bankimpl.cpp,v 1.11 2003/07/04 09:02:01 cstim Exp $
 begin       : Wed Jun 12 2002
 copyright   : (C) 2002 by Martin Preuss
 email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif


#include "bankimpl.h"
#include "accountimpl.h"

namespace HBCI {


BankImpl::BankImpl(const Hbci *hbci,
                   int country,
                   const string &code,
                   const string &server,
                   int hbciversion)
    :Bank()
    ,bankParams(country,code,server)
    ,_hbci(hbci)
    ,_hbciVersion(hbciversion)
{
}


BankImpl::BankImpl(const Hbci *hbci, const bankParams &p,
                   int hbciversion)
:bankParams(p)
,_hbci(hbci)
,_hbciVersion(hbciversion)
{
}

BankImpl::~BankImpl(){
  //fprintf(stderr,"BankImpl::~BankImpl\n");

  // Manually delete the Pointer<User> list since we own these
  // objects but due to cross-referencing User<->Bank the reference
  // counters won't reach zero automatically.
  list<Pointer<User> >::iterator uit;
  for (uit=_users.begin();
       uit!=_users.end();
       uit++) {
      (*uit).release();
  }

  // Manually delete the Pointer<Account> list since we own these
  // objects. It might be possible that due to cross-referencing the
  // reference counters will not reach zero automatically in all
  // cases (although probably mostly they do), so to be on the safe
  // side we will delete these objects here.
  list<Pointer<Account> >::iterator ait;
  for (ait=_accounts.begin();
       ait!=_accounts.end();
       ait++) {
      (*ait).release();
  }
  //fprintf(stderr,"BankImpl::~BankImpl done\n");
}


BankImpl &BankImpl::operator=(const bankParams &p){
  static_cast<bankParams&>(*this)=p;
    return *this;
}


Pointer<User> 
BankImpl::findUser(const string &userid) const {
    list<Pointer<User> >::const_iterator it;

    for (it=_users.begin();
         it!=_users.end();
         it++) {
        if ((*it).ref().userId()==userid)
            return (*it);
    }
    return 0;
}


Pointer<Customer>
BankImpl::findCustomer(const string &id) const {
    list<Pointer<User> >::const_iterator it;
    Pointer<Customer> cu;

    for (it=_users.begin();
         it!=_users.end();
         it++) {
        cu=(*it).ref().findCustomer(id);
        if (cu.isValid())
            return cu;
    }
    return 0;
}


Pointer<Account> 
BankImpl::findAccount(const string &nr,
		      const string &subid) const{
  list<Pointer<Account> >::const_iterator it;
  string nr2;

  if (nr.length()<10)
    nr2=string(10-nr.length(),'0')+nr;
  else
    nr2=nr;

  for (it=_accounts.begin();
       it!=_accounts.end();
       it++) {
    string an2;

    an2=(*it).ref().accountId();
    if (an2.length()<10)
      an2=string(10-an2.length(),'0')+an2;

    if (
	(an2==nr2) &&
	(subid.empty() || ((*it).ref().accountSuffix()==subid)))
      return (*it);
  }
  return 0;
}


const list<Pointer<Account> > &BankImpl::accounts() const {
    return _accounts;
}


const list<Pointer<User> > &BankImpl::users() const {
    return _users;
}


void BankImpl::addAccount(Pointer<Account> a){
    list<Pointer<Account> >::const_iterator it;
    Pointer<Account> na;

    // check if account already exists
    for (it=_accounts.begin();
         it!=_accounts.end();
         it++) {
        /* first check if the very same object already exists.
         * It's not a problem if it does, since it is the SAME.
         */
        if (*it==a) {
#if DEBUGMODE>0
            fprintf(stderr,
                    "Will not add account, since it already IS listed.\n");
#endif
            return;
        }

        /* then check if there already is an object with the same id data.
         * This WOULD be a problem, since that would corrupt the list.
         * The second occurence of an equal account could rarely be accessed.
         */
        if (
            ((*it).ref().accountId()==a.ref().accountId()) &&
            ((*it).ref().accountSuffix()==a.ref().accountSuffix())
           )
            throw Error("BankImpl::addAccount()",
                            ERROR_LEVEL_NORMAL,
                            0,
                            ERROR_ADVISE_DONTKNOW,
                            "account already exists.");
    } // for
    na=a;
    na.setDescription("Entry of BankImpl::_accounts");
    _accounts.push_back(na);
}


void BankImpl::addUser(Pointer<User> c){
    list<Pointer<User> >::const_iterator it;
    Pointer<User> nc;

    for (it=_users.begin();
         it!=_users.end();
         it++) {
        /* first check if the very same object already exists.
         * It's not a problem if it does, since it is the SAME.
         */
        if ((*it)==c) {
#if DEBUGMODE>0
            fprintf(stderr,
                    "Will not add customer, since he already IS listed.\n");
#endif
            return;
        }

        /* then check if there already is an object with the same userid.
         * This WOULD be a problem, since that would corrupt the list.
         * The second occurence of an equal customer could rarely be accessed.
         */
        if ((*it).ref().userId()==c.ref().userId())
            throw Error("BankImpl::addUser()",
                            ERROR_LEVEL_NORMAL,
                            0,
                            ERROR_ADVISE_DONTKNOW,
                            "user already exists.");
    }

    // otherwise add customer
    nc=c;
    nc.setDescription("Entry of BankImpl::_users");
    _users.push_back(nc);
}


void BankImpl::removeUser(Pointer<User> c){
    list<Pointer<User> >::iterator it1;
    list<Pointer<Customer> > custs;
    list<Pointer<Customer> >::iterator it2;
    list<Pointer<Account> >::iterator it3;
    Pointer<AccountImpl> acc;

    // first remove all customers of this user from each account
    custs=c.ref().customers();
    for (it2=custs.begin();
         it2!=custs.end();
         it2++) {
        for (it3=_accounts.begin();
             it3!=_accounts.end();
             it3++) {
            acc=(*it3).cast<AccountImpl>();
            acc.ref().removeAuthorizedCustomer(*it2);
        } // for account
    } // for customer

    // then remove the user itself
    for (it1=_users.begin();
         it1!=_users.end();
         it1++) {
        if (*it1==c) {
            _users.erase(it1);
            break;
        }
    } // for
}


void BankImpl::removeAccount(Pointer<Account> a){
    list<Pointer<Account> >::iterator it1;

    for (it1=_accounts.begin();
         it1!=_accounts.end();
         it1++) {
        if (*it1==a) {
            _accounts.erase(it1);
            break;
        }
    } // for
}

/*
void BankImpl::clear(){
  list<Pointer<User> >::iterator uit;
  list<Pointer<Account> >::iterator ait;

  for (uit=_users.begin();
       uit!=_users.end();
       uit++)
    (*uit).ref().clear();
  _users.clear();

  for (ait=_accounts.begin();
       ait!=_accounts.end();
       ait++)
    (*ait).ref().clear();
  _accounts.clear();

  _messages.clear();
}
*/

} /* namespace HBCI */


