/***************************************************************************
                          hbcidate.cpp  -  description
                             -------------------
    begin                : Fri Aug 3 2001
    copyright            : (C) 2001 by fabian kaiser
    email                : fabian.kaiser@gmx.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include "assert.h"
#include "date.h"
#include "hbcistring.h"


namespace HBCI {

static int sign(int a) 
{ 
    if (a<0) 
	return -1;
    if (a>0)
	return 1;
    return 0;
}

Date::Date() {
    _day = 0;
    _month = 0;
    _year = 0;
}


Date::Date(int day, int month, int year){
    _day = day;
    _month = month;
    _year = year;
}

Date::Date(const struct tm *tm)
{
    assert(tm);
    _day = tm->tm_mday;
    _month = tm->tm_mon + 1;
    _year = tm->tm_year + 1900;
}

    

Date::Date(const string &str, int yearsize){
    string tmp;
    unsigned int pos;

    // initialize
    pos=0;
    _day = 0;
    _month = 0;
    _year = 0;

    if (str.length() < (unsigned int) yearsize+4)
        return;

    // year
    if (yearsize) {
        // yearsize is not zero, so read the year with the given size
        tmp=str.substr(pos,yearsize);
        _year=atoi(tmp.c_str());
        if (_year<100) {
            if (_year>80)
                _year+= 1900;
            else
                _year+=2000;
        } // if

        pos+=yearsize;
    }
    else {
        // year not given, so set it from system
        time_t now;
        time(&now);
        tm *localNow = localtime(&now);
        _year=localNow->tm_year + 1900;
    }

    // now read the rest of the date
    tmp=str.substr(pos,2);
    _month=atoi(tmp.c_str());
    pos+=2;
    tmp=str.substr(pos,2);
    _day=atoi(tmp.c_str());
}


string Date::toString() const {
    // blank date?
	if ( (_day ==0) && (_month == 0) && (_year ==0) )
		return "";
	
	string result;
	result = String::num2string(_year);
	result += String::num2string(_month, true, 2);
	result += String::num2string(_day, true, 2);
	
	return result;
}


bool Date::isValid() const {
   // sorry, but this library outdates in 98 years ;-)
    return (_year>=1900 && _year<2100 &&
            _month>0 && _month<13 &&
            _day>0 && _day<32);
}

struct tm Date::to_tm() const
{
    struct tm t;
    t.tm_mday = _day;
    t.tm_mon = _month - 1;
    t.tm_year = _year - 1900;
    t.tm_hour = 0;
    t.tm_min = 0;
    t.tm_sec = 0;
    t.tm_isdst = -1;
    return t;
}
time_t Date::to_time_t() const
{
    struct tm t = to_tm();
    return mktime(&t);
}

int Date::compare(const Date &date) const {
    if (_year<date._year)
        return -1;
    if (_year>date._year)
        return 1;
    if (_month<date._month)
        return -1;
    if (_month>date._month)
        return 1;
    if (_day<date._day)
        return -1;
    if (_day>date._day)
        return 1;
    // equal
    return 0;
};

int Date::compareTime(const Time& t1, const Date& d2, const Time& t2) const
{
    int result = compare(d2);
    if (result != 0)
	return result;
    return t1.compare(t2);
}

} // namespace HBCI

HBCI_Date* HBCI_Date_new(const struct tm *tm) 
{
    return new HBCI_Date(tm);
}
HBCI_Date* HBCI_Date_new_blank() 
{
    return new HBCI_Date();
}
HBCI_Date *HBCI_Date_new_string(const char *s, int yearsize)
{
    return new HBCI_Date(string(s), yearsize);
}
int HBCI_Date_isValid(const HBCI_Date *h)
{
    assert(h);
    return h->isValid();
}
void HBCI_Date_delete(HBCI_Date *d) 
{
    delete d;
}
struct tm HBCI_Date_to_tm(const HBCI_Date *d)
{
    assert(d);
    return d->to_tm();
}
time_t HBCI_Date_to_time_t(const HBCI_Date *d)
{
    assert(d);
    return d->to_time_t();
}
int HBCI_Date_compare(const HBCI_Date *d1, const HBCI_Date *d2)
{
    assert(d1);
    assert(d2);
    return d1->compare(*d2);
}
int HBCI_Date_compareTime(const HBCI_Date *d1, const HBCI_Time *t1,
			  const HBCI_Date *d2, const HBCI_Time *t2)
{
    assert(d1);
    assert(t1);
    assert(d2);
    assert(t2);
    return d1->compareTime(*t1, *d2, *t2);
}

/******************************************************
 *************  HBCI_Time ***************************
 ******************************************************/


namespace HBCI {

Time::Time():_hour(0),_min(0), _sec(0){
}


Time::Time(int hour, int min, int sec): _hour(hour),
_min(min),_sec(sec)
{
}


Time::Time(const string &hbciTimeFormat) {
    string tmp;

    tmp = hbciTimeFormat.substr(0,2);
    _hour = atoi(tmp.c_str());

    tmp = hbciTimeFormat.substr(2,2);
    _min = atoi(tmp.c_str());

    tmp = hbciTimeFormat.substr(4,2);
    _sec = atoi(tmp.c_str());
}

Time::Time(const struct tm *tm)
{
    assert(tm);
    _hour = tm->tm_hour;
    _min = tm->tm_min;
    _sec = tm->tm_sec;
}

string Time::toString() const {
    string result;
    result=String::num2string(_hour,true,2);
    result+=String::num2string(_min,true,2);
    result+=String::num2string(_sec,true,2);
    return result;
}

struct tm Time::to_tm() const
{
    struct tm t;
    t.tm_mday = 0;
    t.tm_mon = 0;
    t.tm_year = 0;
    t.tm_hour = _hour;
    t.tm_min = _min;
    t.tm_sec = _sec;
    t.tm_isdst = -1;
    return t;
}
int Time::compare(const Time &t) const
{
    if (_hour != t._hour)
	return sign (_hour - t._hour);
    if (_min != t._min)
	return sign (_min - t._min);
    if (_sec != t._sec)
	return sign (_sec - t._sec);
    return 0;
}

} // namespace HBCI

HBCI_Time * HBCI_Time_new(const struct tm *tm)
{
    assert(tm);
    return new HBCI_Time(tm);
}
void HBCI_Time_delete(HBCI_Time *d)
{
    delete d;
}
struct tm HBCI_Time_to_tm(const HBCI_Time *d)
{
    assert(d);
    return d->to_tm();
}
struct tm HBCI_DateTime_to_tm(const HBCI_Date *d,
			      const HBCI_Time *t)
{
    assert(d);
    assert(t);
    struct tm r = d->to_tm();
    r.tm_hour = t->hour();
    r.tm_min = t->minute();
    r.tm_sec = t->second();
    return r;
}
time_t HBCI_DateTime_to_time_t(const HBCI_Date *d,
			       const HBCI_Time *t)
{
    assert(d);
    assert(t);
    struct tm st = HBCI_DateTime_to_tm(d, t);
    return mktime(&st);
}

