/***************************************************************************
 $RCSfile: directory.cpp,v $
                             -------------------
    cvs         : $Id: directory.cpp,v 1.2 2002/07/28 12:05:20 derzach Exp $
    begin       : Tue Dec 18 2001
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#ifdef __declspec
# if BUILDING_DLL
#  define DLLIMPORT __declspec (dllexport)
# else /* Not BUILDING_DLL */
#  define DLLIMPORT __declspec (dllimport)
# endif /* Not BUILDING_DLL */
#else
# define DLLIMPORT
#endif

#include <string>

#include "file.h"
#include "directory.h"

namespace HBCI {

string Directory::_convPath(const string &p){
    unsigned int pos=0;
    string pout;

    while(pos<p.length()) {
        if (p.at(pos)=='/')
            pout+='\\';
        else
            pout+=p[pos];
        pos++;
    }
    return pout;
}


string Directory::_lastErrorString(){
    LPVOID lpMsgBuf;

    FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER |
                  FORMAT_MESSAGE_FROM_SYSTEM |
                  FORMAT_MESSAGE_IGNORE_INSERTS,
                  NULL,
                  GetLastError(),
                  MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // Default language
                  (LPTSTR)&lpMsgBuf,
                  0,NULL);
    return (LPTSTR)lpMsgBuf;
}


Directory::Directory(string name):_name(_convPath(name)),_dirh(DIR_NO_DIRHANDLE){
}


Directory::~Directory(){
    if (_dirh!=DIR_NO_DIRHANDLE)
        FindClose(_dirh);
}


Error Directory::createDirectory(int mode){
    if (!CreateDirectory(_name.c_str(),NULL))
        return Error("Directory::createDirectory()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         _lastErrorString(),
                         "at CreateDirectory()");
    return Error();
}


Error Directory::openDirectory(){
    string n;
    WIN32_FIND_DATA wd;

    n=_name+"/*.*";
    _dirh=FindFirstFile(n.c_str(),&wd);
    if (_dirh==DIR_NO_DIRHANDLE)
        return Error("Directory::openDirectory()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         _lastErrorString(),
                         "at FindFirstFile()");
    _lastEntry=wd.cFileName;
    return Error();
}


Error Directory::readEntry(string &entry){
    WIN32_FIND_DATA wd;

    if (entry.empty())
        return Error("Directory::readEntry()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         "No more entries");

    entry=_lastEntry;
    _lastEntry.erase();

    if (!FindNextFile(_dirh,&wd))
        _lastEntry.erase();
	else
            _lastEntry=wd.cFileName;
    return Error();
}


Error Directory::closeDirectory(){
    BOOL result;

    if (_dirh==DIR_NO_DIRHANDLE)
        return Error();
    result=FindClose(_dirh);
    _dirh=0;
    if (result)
        return Error("Directory::closeDirectory()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         _lastErrorString(),
                         "at FindClose()");
    return Error();
}


string Directory::workingDirectory(){
    char buffer[256];

    if (!GetCurrentDirectory(sizeof(buffer),buffer))
        throw Error("Directory::workingDirectory()",
                        ERROR_LEVEL_NORMAL,
                        0,
                        ERROR_ADVISE_DONTKNOW,
                        _lastErrorString(),
                        "at GetCurrentDirectory()");
    return buffer;
}


Error Directory::setWorkingDirectory(const string &name){
    string n;

    n=_convPath(name);
    if (!SetCurrentDirectory(n.c_str()))
        return Error("Directory::setWorkingDirectory()",
                         ERROR_LEVEL_NORMAL,
                         0,
                         ERROR_ADVISE_DONTKNOW,
                         _lastErrorString(),
                         "at SetCurrentDirectory()");
    return Error();
}


string Directory::homeDirectory(){
    char username[256];
    char windowsdir[256];
    DWORD s;
    string d;

    s=sizeof(windowsdir);
    if (!GetWindowsDirectory(windowsdir,&s))
        throw Error("Directory::homeDirectory()",
                        ERROR_LEVEL_NORMAL,
                        0,
                        ERROR_ADVISE_DONTKNOW,
                        _lastErrorString(),
                        "at GetWindowsDirectory()");
    s=sizeof(username);
    if (!GetUserName(username,&s))
        throw Error("Directory::homeDirectory()",
                        ERROR_LEVEL_NORMAL,
                        0,
                        ERROR_ADVISE_DONTKNOW,
                        _lastErrorString(),
                        "at GetUserName()");
    d=windowsdir;
    d+="\\";
    d+=username;
    return d;
}

} /* namespace  HBCI */

