/* liberty8.h
 */
#ifndef _LIBERTY8_H
#define _LIBERTY8_H

#include "osl/effect/liberty8Table.h"
#include "osl/direction.h"
#include "osl/piece.h"
#include "osl/ptypeList.h"
#include "osl/container/nearMask.h"
#include <boost/type_traits.hpp>
#include <iosfwd>
namespace osl
{
  namespace effect
  {
    /**
     * Liberty8で使われるHelper.
     * Pは defense側
     */
    template<typename Liberty,Player P,Ptype T>
    class AddMaskAction{
      Liberty & liberty;
      NumEffectState const& state;
      const Position target;
      const NearMask nearMask;
    public:
      AddMaskAction(Liberty& l,NumEffectState const& s,Position t,NearMask n) 
	: liberty(l), state(s), target(t), nearMask(n)
      {
      }
      void operator()(Piece p){
#if 1
	const Position from=p.position();
	const NearMask shortMask = Liberty8_Table.
	  getShortMask<PlayerTraits<P>::opponent>(p.ptype(), from, target);
	liberty.andMask(shortMask);
	if(PtypeFuns<T>::hasLongMove &&
	   (T!=LANCE || !p.isPromotedNotKingGold())){
	  LongEffect8 longEffect8=
	    Liberty8_Table.
	    getLongEffect<PlayerTraits<P>::opponent>(p.ptype(),
						     p.position(),
						     target);
	  Offset offset=longEffect8.getOffset();
	  if(offset.zero()) return;
	  // これが引き算で良いかどうかまだ気になる
	  if(state.isEmptyBetween(from,target-offset.blackOffset<P>())){
	    unsigned int nearMaskSpace=nearMask.spaceMask();
	    unsigned int mask0=longEffect8.getMask(0);
	    liberty.andMask(NearMask::makeDirect(~mask0));
	    if((mask0&nearMaskSpace)!=0){
	      unsigned int mask1=longEffect8.getMask(1);
	      liberty.andMask(NearMask::makeDirect(~mask1));
	      if( T!=BISHOP && (mask1&nearMaskSpace)!=0){
		unsigned int mask2=longEffect8.getMask(2);
		liberty.andMask(NearMask::makeDirect(~mask2));
	      }
	    }
	  }
	}
	if(T==ROOK){
	  LongEffect8 longEffect8=
	    Liberty8_Table.
	    getLongEffect2<PlayerTraits<P>::opponent>(p.position(),
						      target);
	  unsigned int mask0=longEffect8.getMask(0);
	  if(mask0==0) return;
	  unsigned int nearMaskSpace=nearMask.spaceMask();
	  liberty.andMask(NearMask::makeDirect(~mask0));
	  if((mask0&nearMaskSpace)==0) return;
	  unsigned int mask1=longEffect8.getMask(1);
	  liberty.andMask(NearMask::makeDirect(~mask1));
	}
#else
	/**
	 * 遅いけれどもほとんど動くバージョン
	 */
	for(int i=0;i<8;i++){
	  Direction dir=static_cast<Direction>(i);
	  Position to=target-Board_Table.getOffset<P>(dir);
	  if(to.isOnBoard() && 
	     state.hasEffectTo(p,to))
	    liberty.andMask(~(1<<i));
	}
	if(state.hasEffectTo(p,target)){
	  Direction longDirection=
	    Board_Table.getLongDirection<P>(target,p.position());
	  // 駒がある方向に長い利きをもっていて
	  // かつ逆方向に短い利きを持っていることはないので，
	  // これで良いことにする
	  if(Ptype_Table.getMoveMask(p.ptype())&dirToMask(longDirection)){
	    liberty.andMask(~(1<<longToShort(longDirection)));
	  }
	}
#endif      
      }
    };

    /**
     * 自分の駒があるマスの8近傍の敵の利きの状態を得る.
     * \li Pからみて, Direction Dに敵の利きがある時に
     * DirectionTraits<D>::mask のビットが立っている
     * 特徴
     * \li longと shortは区別しない
     * \li 自分自身によってブロックされている場合は利きがあることにする
     */
    template<Player P>
    class Liberty8
    {
      /**
       */
      NearMask mask;
    
      template<Ptype T>
      void addMaskPtype(NumEffectState const& state,Position target,NearMask nearMask){
	typedef AddMaskAction<Liberty8<P>,P,T> action_t;
	action_t action(*this,state,target,nearMask);
	state.template
	  forEachOnBoard<PlayerTraits<P>::opponent,T,action_t>(action);
      }

      template<typename U>
      void addMask(NumEffectState const& state,Position target,NearMask nearMask,U);

      void addMask(NumEffectState const&, Position, NearMask, ptl::NullPtype){}

      template<Ptype T,typename Tail>
      void addMask(NumEffectState const& state,Position target,NearMask nearMask,ptl::PtypeList<T,Tail>){
	addMaskPtype<T>(state,target,nearMask);
	addMask(state,target,nearMask,Tail());
      }

    public:
      Liberty8(NumEffectState const& state,Position target);
      void andMask(NearMask m){
	mask&=m;
      }
      NearMask getMask() const{
	return mask;
      }
      /**
       * 8 bit のテーブルを使って速く計算できるが
       */
      int count() const{
	int ret=0;
	for (int i=0;i<8;i++)
	  if (mask.isSet(i))
	    ret++;
	return ret;
      }
    };
    template<Player P>
    std::ostream& operator<<(std::ostream& os,Liberty8<P> const& liberty);
  } // namespace effect
} // namespace osl

template<osl::Player P>
osl::effect::
Liberty8<P>::Liberty8(NumEffectState const& state, Position target)
{
  /**
   * targetには必ず P 側の駒があるべき
   */
  assert(state.getPieceAt(target).template isOnBoardByOwner<P>());
  /**
   * 10近傍の駒の有無を記録
   * 本当は8近傍で良いのだが
   */
  NearMask nearMask=NearMask::make<P>(state,target);
  /**
   * 下位8ビットのみで良い
   * TODO: これの型は NearMask とは別であるべき?
   */
  mask = NearMask::makeDirect(nearMask.uintValue() & 0xff);
  addMask(state,target,nearMask,ptl::PtypeListIsBasic());
}

#endif /* _LIBERTY8_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
