#ifndef _ALWAYS_MOVE_ACTION
#define _ALWAYS_MOVE_ACTION
#include "osl/player.h"
#include "osl/ptype.h"
#include "osl/ptypeTable.h"
#include "osl/ptypeTraits.h"
#include "osl/piece.h"
#include "osl/move_action/concept.h"

namespace osl
{
  namespace effect_action
  {
    /**
     * 全ての指手を生成
     */
    template<class Action>
    class AlwaysMove
    {
      BOOST_CLASS_REQUIRE(Action,osl::move_action,Concept);
    private:
      const NumEffectState& state;
      Action& ac;
    public:
      AlwaysMove(const NumEffectState& s, Action & a) : state(s), ac(a) {}
      /**
       * Ptypeをtemplate引数にできる場合
       */
      template<Player P,Ptype Type>
      void doActionPtype(Piece p1,Square to){
	assert(Type == unpromote(p1.ptype()));
	Square from=p1.square(); 
	if (canPromote(Type) &&
	   !p1.isPromotedNotKingGold() &&
	   (to.canPromote<P>() || from.canPromote<P>())){
	  ac.unknownMove(from,to,state.pieceAt(to),promote(Type),true,P);
	}
	if (!canPromote(Type) ||
	   PtypePlayerTraits<Type,P>::canDropTo(to) ||
	   p1.isPromotedNotKingGold()){
	  ac.unknownMove(from,to,state.pieceAt(to),p1.ptype(),false,P);
	}
      }
      /**
       * Ptypeをtemplate引数にできない場合
       */
      template<Player P>
      void doAction(Piece p1,Square to)
      {
	Square from=p1.square(); 
	Ptype ptype=p1.ptype();
	if(canPromote(ptype))
	{
	  if (to.canPromote<P>())
	  {
	    ac.unknownMove(from,to,state.pieceAt(to),promote(ptype),true,P);
	    if(Ptype_Table.canDropTo(P, ptype,to))
	    {
	      ac.unknownMove(from,to,state.pieceAt(to),ptype,false,P);
	    }
	  }
	  else if (from.canPromote<P>())
	  {
	    ac.unknownMove(from,to,state.pieceAt(to),promote(ptype),true,P);
	    ac.unknownMove(from,to,state.pieceAt(to),ptype,false,P);
	  }
	  else
	  {
	    ac.unknownMove(from,to,state.pieceAt(to),ptype,false,P);
	  }
	}
	else
	{
	  ac.unknownMove(from,to,state.pieceAt(to),ptype,false,P);
	}
      }
      bool done() const{ return false; }
    };
  } // namespace effect_action
} // namespace osl
#endif // _ALWAYS_MOVE_ACTION
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
