#include "osl/move_generator/dropAroundKing8.h"
#include "osl/move_action/store.h"
#include "osl/record/csaString.h"
#include "osl/record/csaRecord.h"
#include "osl/move.h"
#include "osl/container/moveVector.h"

#include <cppunit/TestCase.h>
#include <cppunit/extensions/HelperMacros.h>

#include <iostream>

using namespace osl;
using namespace osl::move_action;
using namespace osl::move_generator;

class DropAroundKing8Test : public CppUnit::TestFixture 
{
  CPPUNIT_TEST_SUITE(DropAroundKing8Test);
  CPPUNIT_TEST(testDropAroundKing8Simple0);
  CPPUNIT_TEST_SUITE_END();
public:
  void testDropAroundKing8Simple0()
  {
    NumEffectState state=CsaString(
      "P1 *  *  *  *  *  *  * -OU * \n"
      "P2 *  *  *  *  *  *  *  *  * \n"
      "P3 *  *  *  *  *  *  * +FU * \n"
      "P4 *  *  *  *  *  *  *  *  * \n"
      "P5 *  *  *  *  *  *  *  *  * \n"
      "P6 *  *  *  *  *  *  *  *  * \n"
      "P7 *  *  *  *  *  *  *  *  * \n"
      "P8 *  * +OU *  *  *  *  *  * \n"
      "P9 *  *  *  *  *  *  *  *  * \n"
      "P+00KI\n"
      "P-00AL\n"
      "-\n").getInitialState();
    {
      MoveVector moves;
      {
	Store store(moves);
	DropAroundKing8<BLACK>::generate(state, store);
      }
      CPPUNIT_ASSERT_EQUAL((size_t)8u, moves.size());
    }

    {
      MoveVector moves;
      {
	Store store(moves);
	DropAroundKing8<WHITE>::generate(state, store);
      }
      CPPUNIT_ASSERT_EQUAL((size_t)7 * 7u, moves.size());
    }
  }
};

CPPUNIT_TEST_SUITE_REGISTRATION(DropAroundKing8Test);

// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
