/* 
 * pam_rsa PAM-module for local authentication with RSA keypairs
 * copyright (c) 2006 Vesa-Matti Kari <hyperllama@laamanaama.helsinki.fi>
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or (at your option) any later version.
 * 
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 */

#include <stdio.h>
#include <string.h>
#include <openssl/evp.h>

int sha1head(const char *from, char *to, int len)
{
	EVP_MD_CTX mdctx;
	const EVP_MD *md;
	unsigned char mdval[EVP_MAX_MD_SIZE];
	char buf[(EVP_MAX_MD_SIZE * 2) + 1];
	unsigned int mdlen;
	static const int sha1maxlen = 40;
	int i, j;

	if (len < 1 || len > sha1maxlen) {
		return -1;
	}

	if (!(md = EVP_get_digestbyname("sha1"))) {
		return -2;
	}

	EVP_MD_CTX_init(&mdctx);

	if (!(EVP_DigestInit_ex(&mdctx, md, NULL))) {
		return -3;
	}

	if (!(EVP_DigestUpdate(&mdctx, from, strlen(from)))) {
		return -4;
	}

	if (!(EVP_DigestFinal_ex(&mdctx, mdval, &mdlen))) {
		return -5;
	}

	if (!(EVP_MD_CTX_cleanup(&mdctx))) {
		return -6;
	}

	memset(buf, 0x0, sizeof(buf));

	for (i = 0, j = 0; i < (int)mdlen; i++, j += 2) {
		sprintf(&buf[j], "%02x", mdval[i]);
	}

	strncpy(to, buf, len);

	return 0;
}
