if (Array.length Sys.argv <> 2) then 
  (Printf.eprintf "\n Usage:  %s conninfo\n" Sys.argv.(0); exit 1);;
let conninfo = Sys.argv.(1);;

let main() =
  let c = new Postgres.connection conninfo in
  let _ = c#exec_expect "begin" [Postgres.Result.Command_ok] in
  let oid = c#lo_create in
  let lo  = c#lo_open oid in
  c#lo_write_string lo "Hello world !\n";
  c#lo_close lo;
  c#lo_export oid "/dev/stdout";
  let _ = c#exec_expect "end" [Postgres.Result.Command_ok] in
  c#close

let _ = 
  try main ()
  with 
    | Postgres.Error e -> prerr_endline (Postgres.string_of_error e)
    | e -> prerr_endline (Printexc.to_string e)
