/****************************************************************************

 Copyright (C) 2002-2008 Gilles Debunne. All rights reserved.

 This file is part of the QGLViewer library version 2.3.4.

 http://www.libqglviewer.com - contact@libqglviewer.com

 This file may be used under the terms of the GNU General Public License 
 versions 2.0 or 3.0 as published by the Free Software Foundation and
 appearing in the LICENSE file included in the packaging of this file.
 In addition, as a special exception, Gilles Debunne gives you certain 
 additional rights, described in the file GPL_EXCEPTION in this package.

 libQGLViewer uses dual licensing. Commercial/proprietary software must
 purchase a libQGLViewer Commercial License.

 This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

*****************************************************************************/

/****************************************************************************
** Form implementation generated from reading ui file 'ImageInterface.Qt3.ui'
**
** Created: lun. août 31 22:38:22 2009
**
** WARNING! All changes made in this file will be lost!
****************************************************************************/

#include "ImageInterface.Qt3.h"

#include <qvariant.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qspinbox.h>
#include <qcheckbox.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>

static const unsigned char image0_data[] = { 
    0x89, 0x50, 0x4e, 0x47, 0x0d, 0x0a, 0x1a, 0x0a, 0x00, 0x00, 0x00, 0x0d,
    0x49, 0x48, 0x44, 0x52, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x10,
    0x08, 0x06, 0x00, 0x00, 0x00, 0xc9, 0x56, 0x25, 0x04, 0x00, 0x00, 0x03,
    0x4b, 0x49, 0x44, 0x41, 0x54, 0x28, 0x91, 0x75, 0x93, 0x6b, 0x6c, 0x93,
    0x65, 0x14, 0xc7, 0xcf, 0x79, 0xde, 0xb7, 0x7d, 0x7b, 0xa1, 0xdd, 0xda,
    0x8e, 0x6e, 0xa1, 0x73, 0xb2, 0xb5, 0x74, 0xab, 0xb3, 0x8e, 0x0e, 0xe5,
    0x92, 0x39, 0x36, 0x2b, 0x53, 0x42, 0x82, 0x9a, 0xe8, 0xb8, 0x24, 0x26,
    0x26, 0xc6, 0x68, 0x62, 0x96, 0x20, 0x1a, 0x09, 0x09, 0x24, 0xc6, 0x2f,
    0xc6, 0x20, 0x8c, 0x20, 0x97, 0x2f, 0x2c, 0x46, 0x82, 0xf3, 0x83, 0xc4,
    0x49, 0x60, 0x8a, 0x80, 0x53, 0x33, 0xa6, 0x33, 0x20, 0x6c, 0x73, 0x63,
    0xdd, 0x6a, 0xda, 0xcd, 0xca, 0x6a, 0xa1, 0x17, 0xd6, 0xee, 0x5d, 0xdf,
    0xbe, 0xb7, 0xe7, 0xf1, 0x0b, 0x8b, 0x8a, 0x7a, 0x92, 0xff, 0xb7, 0xdf,
    0xc9, 0x3f, 0x39, 0xf9, 0x1d, 0x64, 0x8c, 0xc1, 0xff, 0x4d, 0x3e, 0x9b,
    0xf5, 0x5c, 0x3e, 0xde, 0xf3, 0x5e, 0x5d, 0x20, 0x70, 0x33, 0xf4, 0xc2,
    0xd6, 0x83, 0x88, 0x48, 0x19, 0xa5, 0x9c, 0x78, 0xb9, 0xef, 0x65, 0xce,
    0xb5, 0x3c, 0x0b, 0x8c, 0xb1, 0x7f, 0x44, 0x51, 0x54, 0xe1, 0xb7, 0x58,
    0x72, 0xbd, 0x54, 0x94, 0xca, 0xce, 0x1c, 0x39, 0xd6, 0xbd, 0xd7, 0xbf,
    0x56, 0xfe, 0xf4, 0xc5, 0xae, 0x11, 0x65, 0xb1, 0xe8, 0x64, 0x8c, 0x81,
    0x38, 0x78, 0x61, 0xfb, 0x6c, 0xfb, 0x8a, 0x4c, 0xee, 0xfd, 0xdd, 0x9f,
    0x10, 0x00, 0x00, 0xc6, 0x18, 0x47, 0x29, 0x33, 0x00, 0x00, 0x44, 0x46,
    0xe3, 0x4f, 0x9e, 0x3d, 0xf5, 0xc3, 0x9e, 0x3b, 0xc9, 0xd4, 0xa3, 0x4d,
    0x6d, 0x1b, 0xbf, 0xd9, 0xf0, 0x54, 0xc7, 0x15, 0x52, 0x28, 0x2d, 0xd7,
    0x65, 0xd5, 0x06, 0x00, 0x40, 0xe7, 0x66, 0x7c, 0x86, 0x74, 0xd2, 0x45,
    0x66, 0xa7, 0x1a, 0x08, 0x00, 0x83, 0x89, 0x9b, 0xb7, 0x3a, 0xf2, 0x79,
    0xd1, 0x03, 0x00, 0x5c, 0x74, 0xec, 0xce, 0x0e, 0xb3, 0xd9, 0xa1, 0x5a,
    0x6d, 0x96, 0xa2, 0xaf, 0x29, 0x78, 0xd1, 0xe5, 0xae, 0x4a, 0x5b, 0xcc,
    0x56, 0x89, 0x18, 0xf8, 0x12, 0x00, 0x80, 0x50, 0xe9, 0x49, 0x99, 0x8d,
    0x02, 0x70, 0x72, 0xd1, 0x44, 0xc6, 0xa3, 0x5a, 0xf8, 0xeb, 0x6f, 0xa7,
    0x3b, 0x79, 0x1e, 0xf3, 0xaa, 0xa2, 0x3d, 0x30, 0x17, 0xd7, 0x42, 0xde,
    0x80, 0xe7, 0x57, 0xbb, 0xa3, 0x6c, 0x86, 0x69, 0xba, 0x41, 0xc9, 0x14,
    0xaa, 0x6d, 0x55, 0x95, 0x49, 0xde, 0x24, 0x14, 0x00, 0x00, 0x88, 0xae,
    0x13, 0x03, 0x22, 0xf0, 0x82, 0x45, 0x21, 0xa9, 0x1c, 0xae, 0x0c, 0xb7,
    0xfa, 0x86, 0xac, 0x56, 0x73, 0x3e, 0x11, 0x2b, 0x34, 0xe7, 0xd2, 0xcc,
    0xba, 0x2a, 0x58, 0x31, 0xc6, 0xf3, 0xc6, 0x8c, 0x3c, 0x5f, 0x58, 0xb1,
    0x98, 0x48, 0x7b, 0x5d, 0xfe, 0xba, 0x71, 0xe4, 0x39, 0x09, 0x00, 0x00,
    0xb2, 0xa9, 0x4a, 0x9e, 0x52, 0xe0, 0xdc, 0x9e, 0x39, 0xbe, 0x63, 0x1d,
    0x77, 0xaa, 0x58, 0x74, 0x3f, 0x44, 0x29, 0x9a, 0x2f, 0xf5, 0xfd, 0xbe,
    0xbd, 0x66, 0x95, 0xf3, 0xba, 0xcb, 0x6d, 0x8a, 0x23, 0xa2, 0x76, 0x77,
    0x72, 0xb6, 0x45, 0x99, 0x2f, 0x3a, 0x2b, 0x56, 0x07, 0x06, 0xf1, 0xde,
    0x6d, 0x60, 0x66, 0xaa, 0x91, 0x20, 0x01, 0xe2, 0x6d, 0x9c, 0xe0, 0x19,
    0x00, 0x1d, 0x1e, 0x8e, 0xb4, 0x45, 0xc7, 0xd4, 0xae, 0xd1, 0x6b, 0x0b,
    0xad, 0xbb, 0xdf, 0x6d, 0xda, 0x05, 0x08, 0x22, 0xd5, 0x75, 0x63, 0x62,
    0xe0, 0x6a, 0xa7, 0xb9, 0xaa, 0x22, 0xe9, 0x08, 0xac, 0x1c, 0x06, 0x00,
    0x00, 0x31, 0xef, 0x86, 0xc8, 0xc8, 0x6a, 0xb4, 0x97, 0x97, 0xb0, 0xb1,
    0xf9, 0x27, 0x82, 0x88, 0x6c, 0x3a, 0x92, 0xaa, 0xed, 0x39, 0xf1, 0xe3,
    0xab, 0xa1, 0xc7, 0xcb, 0x07, 0xaa, 0x6b, 0xcd, 0x23, 0x94, 0x31, 0x39,
    0x3b, 0x39, 0xd3, 0x96, 0x18, 0xfa, 0x25, 0x5c, 0xdd, 0xbe, 0xe6, 0xbc,
    0x50, 0x6e, 0x9b, 0x03, 0x00, 0x60, 0xd3, 0x63, 0xeb, 0x58, 0x2c, 0x52,
    0x07, 0xb5, 0x0d, 0x71, 0xf4, 0x3d, 0x7c, 0x9d, 0x07, 0x00, 0x68, 0xdd,
    0x18, 0xec, 0x07, 0x6d, 0x99, 0xbd, 0xf1, 0x11, 0x3a, 0x29, 0xcb, 0x25,
    0x8b, 0xba, 0x20, 0x55, 0x8c, 0x9e, 0x3c, 0xb7, 0x1f, 0x4d, 0x82, 0x54,
    0xb3, 0x79, 0xc3, 0x69, 0x44, 0xa4, 0x4c, 0xd7, 0x8c, 0xfa, 0xa5, 0xbe,
    0x9d, 0x74, 0x51, 0x34, 0x72, 0xeb, 0x37, 0x0d, 0x80, 0xdd, 0x91, 0xc4,
    0x25, 0xc3, 0x18, 0xa3, 0x7c, 0xef, 0xd1, 0x8f, 0x0f, 0x98, 0x90, 0xb3,
    0x48, 0xe3, 0x89, 0xb5, 0xe2, 0x8d, 0x58, 0x53, 0x4b, 0x57, 0xe7, 0x07,
    0xc1, 0x97, 0xb6, 0xec, 0x43, 0x44, 0x5d, 0x9f, 0xf8, 0xf9, 0x69, 0xf9,
    0x8d, 0x6d, 0x9f, 0x21, 0x41, 0x26, 0x1c, 0x3b, 0xbb, 0x95, 0xf8, 0x83,
    0x57, 0xc8, 0x92, 0x8a, 0x88, 0x44, 0xb3, 0xd9, 0x6c, 0xb9, 0xfe, 0xee,
    0xde, 0xd7, 0x62, 0x43, 0xe3, 0xa1, 0x9a, 0xf0, 0x9a, 0x8b, 0xf5, 0xcf,
    0xb7, 0x1f, 0x46, 0x44, 0x9d, 0x2e, 0xe4, 0xdd, 0xc5, 0x8f, 0xba, 0xf7,
    0xaa, 0xe9, 0xdb, 0x76, 0x12, 0x7e, 0xee, 0x2b, 0xac, 0x0b, 0x5c, 0xbd,
    0xd7, 0xf8, 0x97, 0x9a, 0xd9, 0xdb, 0x19, 0x6f, 0xcf, 0x5b, 0x07, 0xce,
    0x1f, 0xdd, 0xb1, 0x6b, 0x22, 0x9f, 0xca, 0xd4, 0x33, 0xc6, 0x40, 0x17,
    0x17, 0x9c, 0xd9, 0x43, 0xfb, 0x4f, 0xfe, 0x11, 0x72, 0xe8, 0x77, 0x9f,
    0x0d, 0xdd, 0xd2, 0xe2, 0x53, 0x8f, 0x2d, 0xf1, 0x78, 0xff, 0x63, 0xc8,
    0x92, 0xe4, 0xec, 0xdd, 0xf3, 0x66, 0xaf, 0xf7, 0xc1, 0xea, 0xa8, 0xaf,
    0xbe, 0x21, 0x5a, 0xfa, 0xae, 0xff, 0x19, 0xfd, 0xfb, 0xfe, 0x4d, 0x16,
    0x93, 0xa0, 0xb8, 0xf6, 0x1d, 0x7a, 0xdb, 0xb4, 0x65, 0xdb, 0x71, 0x44,
    0x64, 0xff, 0x6a, 0x5e, 0xca, 0xe8, 0xb9, 0x2f, 0x5e, 0x39, 0xd2, 0xe0,
    0x91, 0x3f, 0xf7, 0xbb, 0xd8, 0xa0, 0xbf, 0x8c, 0x4d, 0xb6, 0xd4, 0x8a,
    0xf3, 0xa7, 0x4f, 0xbc, 0x43, 0x55, 0x45, 0xf8, 0x3b, 0xf7, 0x9f, 0xcb,
    0x6a, 0x49, 0x5a, 0x76, 0xed, 0xc3, 0x83, 0x87, 0xbf, 0x7c, 0xa2, 0x39,
    0x7d, 0x63, 0xe7, 0xe6, 0x48, 0xee, 0x42, 0xdf, 0xeb, 0x54, 0x55, 0x85,
    0xfb, 0xb9, 0x3f, 0x01, 0xb2, 0x2d, 0xcb, 0x16, 0xd1, 0x81, 0x19, 0x0d,
    0x00, 0x00, 0x00, 0x00, 0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82
};


/*
 *  Constructs a ImageInterface as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ImageInterface::ImageInterface( QWidget* parent, const char* name, bool modal, WFlags fl )
    : QDialog( parent, name, modal, fl )
{
    QImage img;
    img.loadFromData( image0_data, sizeof( image0_data ), "PNG" );
    image0 = img;
    if ( !name )
	setName( "ImageInterface" );
    setIcon( image0 );
    ImageInterfaceLayout = new QVBoxLayout( this, 11, 6, "ImageInterfaceLayout"); 

    layout5 = new QHBoxLayout( 0, 0, 6, "layout5"); 

    textLabel1 = new QLabel( this, "textLabel1" );
    layout5->addWidget( textLabel1 );

    imgWidth = new QSpinBox( this, "imgWidth" );
    imgWidth->setMaxValue( 32000 );
    imgWidth->setMinValue( 1 );
    layout5->addWidget( imgWidth );

    textLabel2 = new QLabel( this, "textLabel2" );
    layout5->addWidget( textLabel2 );

    imgHeight = new QSpinBox( this, "imgHeight" );
    imgHeight->setMaxValue( 32000 );
    imgHeight->setMinValue( 1 );
    layout5->addWidget( imgHeight );
    ImageInterfaceLayout->addLayout( layout5 );

    layout2 = new QHBoxLayout( 0, 0, 6, "layout2"); 

    textLabel3 = new QLabel( this, "textLabel3" );
    layout2->addWidget( textLabel3 );

    imgQuality = new QSpinBox( this, "imgQuality" );
    imgQuality->setMaxValue( 100 );
    layout2->addWidget( imgQuality );
    spacer1 = new QSpacerItem( 271, 31, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout2->addItem( spacer1 );
    ImageInterfaceLayout->addLayout( layout2 );

    layout2_2 = new QHBoxLayout( 0, 0, 6, "layout2_2"); 

    textLabel3_2 = new QLabel( this, "textLabel3_2" );
    layout2_2->addWidget( textLabel3_2 );

    oversampling = new QSpinBox( this, "oversampling" );
    oversampling->setMaxValue( 64 );
    oversampling->setMinValue( 1 );
    layout2_2->addWidget( oversampling );
    spacer1_2 = new QSpacerItem( 271, 31, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout2_2->addItem( spacer1_2 );
    ImageInterfaceLayout->addLayout( layout2_2 );

    whiteBackground = new QCheckBox( this, "whiteBackground" );
    ImageInterfaceLayout->addWidget( whiteBackground );

    expandFrustum = new QCheckBox( this, "expandFrustum" );
    ImageInterfaceLayout->addWidget( expandFrustum );

    layout4 = new QHBoxLayout( 0, 0, 6, "layout4"); 
    spacer3 = new QSpacerItem( 251, 21, QSizePolicy::Expanding, QSizePolicy::Minimum );
    layout4->addItem( spacer3 );

    pushButton1 = new QPushButton( this, "pushButton1" );
    layout4->addWidget( pushButton1 );

    pushButton2 = new QPushButton( this, "pushButton2" );
    layout4->addWidget( pushButton2 );
    ImageInterfaceLayout->addLayout( layout4 );
    languageChange();
    resize( QSize(288, 213).expandedTo(minimumSizeHint()) );
    clearWState( WState_Polished );

    // signals and slots connections
    connect( pushButton1, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( pushButton2, SIGNAL( clicked() ), this, SLOT( reject() ) );
}

/*
 *  Destroys the object and frees any allocated resources
 */
ImageInterface::~ImageInterface()
{
    // no need to delete child widgets, Qt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void ImageInterface::languageChange()
{
    setCaption( tr( "Image settings" ) );
    textLabel1->setText( tr( "Width" ) );
    imgWidth->setSuffix( tr( " px" ) );
    QToolTip::add( imgWidth, tr( "Width of the image (in pixels)" ) );
    textLabel2->setText( tr( "Height" ) );
    imgHeight->setPrefix( QString::null );
    imgHeight->setSuffix( tr( " px" ) );
    QToolTip::add( imgHeight, tr( "Height of the image (in pixels)" ) );
    textLabel3->setText( tr( "Image quality" ) );
    QToolTip::add( imgQuality, tr( "Between 0 (smallest files) and 100 (highest quality)" ) );
    textLabel3_2->setText( tr( "Oversampling" ) );
    QToolTip::add( textLabel3_2, QString::null );
    oversampling->setPrefix( tr( "x " ) );
    QToolTip::add( oversampling, tr( "Antialiases image (when larger then 1.0)" ) );
    whiteBackground->setText( tr( "Use white background" ) );
    QToolTip::add( whiteBackground, tr( "Use white as background color" ) );
    expandFrustum->setText( tr( "Expand frustum if needed" ) );
    QToolTip::add( expandFrustum, tr( "When image aspect ratio differs from viewer's one, expand frustum as needed. Fits inside current frustum otherwise." ) );
    pushButton1->setText( tr( "OK" ) );
    pushButton2->setText( tr( "Cancel" ) );
}

