# - This is a support module for easy Mono/C# handling with CMake
# It defines the following macros:
#
# ADD_CS_LIBRARY (<target> <source> [ALL])
# ADD_CS_EXECUTABLE (<target> <source> [ALL])
#
# Note that the order of the arguments is important (including "ALL").
# It is recommended that you quote the arguments, especially <source>, if
# you have more than one source file.
#
# You can optionally set the variable CS_FLAGS to tell the macros whether
# to pass additional flags to the compiler. This is particularly useful to
# set assembly references, unsafe code, etc... These flags are always reset
# after the target was added so you don't have to care about that.
#

MACRO(ADD_CS_LIBRARY target source)
	IF (NOT LIBRARY_OUTPUT_PATH)
		SET(CS_LIBRARY_TARGET_DIR ${CMAKE_CURRENT_BINARY_DIR})
	ELSE (NOT LIBRARY_OUTPUT_PATH)
		SET(CS_LIBRARY_TARGET_DIR ${LIBRARY_OUTPUT_PATH})
	ENDIF (NOT LIBRARY_OUTPUT_PATH)
	
	SET(target_DLL "${CS_LIBRARY_TARGET_DIR}/${target}.dll")
	
	ADD_CUSTOM_COMMAND (OUTPUT ${target_DLL}
		COMMAND ${GMCS_EXECUTABLE} ${CS_FLAGS} -out:${target_DLL} -target:library ${source}
		DEPENDS ${source}
		COMMENT "Building ${target_DLL}")
	ADD_CUSTOM_TARGET (${target} ${ARGV2} DEPENDS ${target_DLL})
	SET(CS_FLAGS "")
ENDMACRO(ADD_CS_LIBRARY)

MACRO(ADD_CS_EXECUTABLE target source)
	IF (NOT EXECUTABLE_OUTPUT_PATH)
		SET(CS_EXECUTABLE_TARGET_DIR ${CMAKE_CURRENT_BINARY_DIR})
	ELSE (NOT EXECUTABLE_OUTPUT_PATH)
		SET(CS_EXECUTABLE_TARGET_DIR ${EXECUTABLE_OUTPUT_PATH})
	ENDIF (NOT EXECUTABLE_OUTPUT_PATH)
	
	# FIXME:
	# Seems like cmake doesn't like the ".exe" ending for custom commands.
	# If we call it ${target}.exe, 'make' will later complain about a missing rule.
	# mono doesn't care about endings, so temporarily add ".monoexe".
	SET(target_EXE "${CS_EXECUTABLE_TARGET_DIR}/${target}.monoexe")
	
	ADD_CUSTOM_COMMAND (OUTPUT "${target_EXE}"
		COMMAND ${GMCS_EXECUTABLE} ${CS_FLAGS} -out:${target_EXE} ${source}
		DEPENDS ${source}
		COMMENT "Building ${target_EXE}")
	ADD_CUSTOM_TARGET ("${target}" "${ARGV2}" DEPENDS "${target_EXE}")
	SET(CS_FLAGS "")
ENDMACRO(ADD_CS_EXECUTABLE)

MACRO(INSTALL_GAC target)
	IF (NOT LIBRARY_OUTPUT_PATH)
		SET(CS_LIBRARY_TARGET_DIR ${CMAKE_CURRENT_BINARY_DIR})
	ELSE (NOT LIBRARY_OUTPUT_PATH)
		SET(CS_LIBRARY_TARGET_DIR ${LIBRARY_OUTPUT_PATH})
	ENDIF (NOT LIBRARY_OUTPUT_PATH)

	INSTALL(CODE "EXECUTE_PROCESS(COMMAND ${GACUTIL_EXECUTABLE} -i ${CS_LIBRARY_TARGET_DIR}/${target}.dll)")
ENDMACRO(INSTALL_GAC target)
