//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qcursor_c.h"

QCursorH QCursor_create()
{
	return (QCursorH) new QCursor();
}

void QCursor_destroy(QCursorH handle)
{
	delete (QCursor *)handle;
}

QCursorH QCursor_create2(Qt::CursorShape shape)
{
	return (QCursorH) new QCursor(shape);
}

QCursorH QCursor_create3(const QBitmapH bitmap, const QBitmapH mask, int hotX, int hotY)
{
	return (QCursorH) new QCursor(*(const QBitmap*)bitmap, *(const QBitmap*)mask, hotX, hotY);
}

QCursorH QCursor_create4(const QPixmapH pixmap, int hotX, int hotY)
{
	return (QCursorH) new QCursor(*(const QPixmap*)pixmap, hotX, hotY);
}

QCursorH QCursor_create5(const QCursorH cursor)
{
	return (QCursorH) new QCursor(*(const QCursor*)cursor);
}

Qt::CursorShape QCursor_shape(QCursorH handle)
{
	return (Qt::CursorShape) ((QCursor *)handle)->shape();
}

void QCursor_setShape(QCursorH handle, Qt::CursorShape newShape)
{
	((QCursor *)handle)->setShape(newShape);
}

const QBitmapH QCursor_bitmap(QCursorH handle)
{
	return (const QBitmapH) ((QCursor *)handle)->bitmap();
}

const QBitmapH QCursor_mask(QCursorH handle)
{
	return (const QBitmapH) ((QCursor *)handle)->mask();
}

void QCursor_pixmap(QCursorH handle, QPixmapH retval)
{
	*(QPixmap *)retval = ((QCursor *)handle)->pixmap();
}

void QCursor_hotSpot(QCursorH handle, PQtPoint retval)
{
	*(QPoint *)retval = ((QCursor *)handle)->hotSpot();
}

void QCursor_pos(PQtPoint retval)
{
	*(QPoint *)retval = QCursor::pos();
}

void QCursor_setPos(int x, int y)
{
	QCursor::setPos(x, y);
}

void QCursor_setPos2(const QPointH p)
{
	QCursor::setPos(*(const QPoint*)p);
}

#if defined BINUX || DARWIN
Qt::HANDLE QCursor_handle(QCursorH handle)
{
	return (Qt::HANDLE) ((QCursor *)handle)->handle();
}

#endif
#if defined BINUX
QCursorH QCursor_create6(Qt::HANDLE cursor)
{
	return (QCursorH) new QCursor(cursor);
}

int QCursor_x11Screen()
{
	return (int) QCursor::x11Screen();
}

#endif
#if defined MSWINDOWS
HCURSOR QCursor_handle2(QCursorH handle)
{
	return (HCURSOR) ((QCursor *)handle)->handle();
}

QCursorH QCursor_create7(HCURSOR cursor)
{
	return (QCursorH) new QCursor(cursor);
}

#endif
#if defined QTOPIA
int QCursor_handle3(QCursorH handle)
{
	return (int) ((QCursor *)handle)->handle();
}

#endif
