//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#ifndef QNETWORKPROXY_C_H
#define QNETWORKPROXY_C_H

#include <QtNetwork>
#include "pascalbind.h"

C_EXPORT QNetworkProxyQueryH QNetworkProxyQuery_create();
C_EXPORT void QNetworkProxyQuery_destroy(QNetworkProxyQueryH handle);
C_EXPORT QNetworkProxyQueryH QNetworkProxyQuery_create2(const QUrlH requestUrl, QNetworkProxyQuery::QueryType queryType);
C_EXPORT QNetworkProxyQueryH QNetworkProxyQuery_create3(PWideString hostname, int port, PWideString protocolTag, QNetworkProxyQuery::QueryType queryType);
C_EXPORT QNetworkProxyQueryH QNetworkProxyQuery_create4(quint16 bindPort, PWideString protocolTag, QNetworkProxyQuery::QueryType queryType);
C_EXPORT QNetworkProxyQueryH QNetworkProxyQuery_create5(const QNetworkProxyQueryH other);
C_EXPORT QNetworkProxyQuery::QueryType QNetworkProxyQuery_queryType(QNetworkProxyQueryH handle);
C_EXPORT void QNetworkProxyQuery_setQueryType(QNetworkProxyQueryH handle, QNetworkProxyQuery::QueryType type);
C_EXPORT int QNetworkProxyQuery_peerPort(QNetworkProxyQueryH handle);
C_EXPORT void QNetworkProxyQuery_setPeerPort(QNetworkProxyQueryH handle, int port);
C_EXPORT void QNetworkProxyQuery_peerHostName(QNetworkProxyQueryH handle, PWideString retval);
C_EXPORT void QNetworkProxyQuery_setPeerHostName(QNetworkProxyQueryH handle, PWideString hostname);
C_EXPORT int QNetworkProxyQuery_localPort(QNetworkProxyQueryH handle);
C_EXPORT void QNetworkProxyQuery_setLocalPort(QNetworkProxyQueryH handle, int port);
C_EXPORT void QNetworkProxyQuery_protocolTag(QNetworkProxyQueryH handle, PWideString retval);
C_EXPORT void QNetworkProxyQuery_setProtocolTag(QNetworkProxyQueryH handle, PWideString protocolTag);
C_EXPORT void QNetworkProxyQuery_url(QNetworkProxyQueryH handle, QUrlH retval);
C_EXPORT void QNetworkProxyQuery_setUrl(QNetworkProxyQueryH handle, const QUrlH url);
C_EXPORT QNetworkProxyH QNetworkProxy_create();
C_EXPORT void QNetworkProxy_destroy(QNetworkProxyH handle);
C_EXPORT QNetworkProxyH QNetworkProxy_create2(QNetworkProxy::ProxyType type, PWideString hostName, quint16 port, PWideString user, PWideString password);
C_EXPORT QNetworkProxyH QNetworkProxy_create3(const QNetworkProxyH other);
C_EXPORT void QNetworkProxy_setType(QNetworkProxyH handle, QNetworkProxy::ProxyType type);
C_EXPORT QNetworkProxy::ProxyType QNetworkProxy_type(QNetworkProxyH handle);
C_EXPORT void QNetworkProxy_setCapabilities(QNetworkProxyH handle, unsigned int capab);
C_EXPORT unsigned int QNetworkProxy_capabilities(QNetworkProxyH handle);
C_EXPORT bool QNetworkProxy_isCachingProxy(QNetworkProxyH handle);
C_EXPORT bool QNetworkProxy_isTransparentProxy(QNetworkProxyH handle);
C_EXPORT void QNetworkProxy_setUser(QNetworkProxyH handle, PWideString userName);
C_EXPORT void QNetworkProxy_user(QNetworkProxyH handle, PWideString retval);
C_EXPORT void QNetworkProxy_setPassword(QNetworkProxyH handle, PWideString password);
C_EXPORT void QNetworkProxy_password(QNetworkProxyH handle, PWideString retval);
C_EXPORT void QNetworkProxy_setHostName(QNetworkProxyH handle, PWideString hostName);
C_EXPORT void QNetworkProxy_hostName(QNetworkProxyH handle, PWideString retval);
C_EXPORT void QNetworkProxy_setPort(QNetworkProxyH handle, quint16 port);
C_EXPORT quint16 QNetworkProxy_port(QNetworkProxyH handle);
C_EXPORT void QNetworkProxy_setApplicationProxy(const QNetworkProxyH proxy);
C_EXPORT void QNetworkProxy_applicationProxy(QNetworkProxyH retval);
C_EXPORT void QNetworkProxyFactory_setApplicationProxyFactory(QNetworkProxyFactoryH factory);

#endif
