/* This is a roxen module.
 *
 * Add a tag <remote_user> which will display the user name on
 * authenticated pages.
 */

constant cvs_version = "$Id: remote_user.pike,v 1.1 1999/07/10 21:39:31 hjp Exp $";
constant thread_safe=1;

#include <module.h>
inherit "module";

void create()
{
  //defvar( "var", 1, "short desc", TYPE_FLAG|VAR_MORE, "long desc"
}

mixed register_module()
{
  return ({ 
    MODULE_PARSER,
    "Remote_user tag",
    (
     "This module defines a tag &lt;remote_user&gt;, which resolves to"
     "the name name of the authenticated user on protected pages"
     "(otherwise an empty string)."
     ), ({}), 1,
  });
}

string tag_remote_user( string tag, mapping m, object id )
{
  //NOCACHE();

  if(m->help) return register_module()[2];
  
  if( id->realauth ) return (id->realauth / ":")[0];
  else		     return "";
  
}

mapping query_tag_callers()
{
  return ([ "remote_user" : tag_remote_user ]);
}
